@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.ConnectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Connect.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import com.pulumi.aws.ec2transitgateway.Connect;
 * import com.pulumi.aws.ec2transitgateway.ConnectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetIds(aws_subnet.example().id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *         var attachment = new Connect("attachment", ConnectArgs.builder()
 *             .transportAttachmentId(example.id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_connect` using the EC2 Transit Gateway Connect identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/connect:Connect example tgw-attach-12345678
 * ```
 * @property protocol The tunnel protocol. Valid values: `gre`. Default is `gre`.
 * @property tags Key-value tags for the EC2 Transit Gateway Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayDefaultRouteTableAssociation Boolean whether the Connect should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
 * @property transitGatewayDefaultRouteTablePropagation Boolean whether the Connect should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
 * @property transitGatewayId Identifier of EC2 Transit Gateway.
 * @property transportAttachmentId The underlaying VPC attachment
 */
public data class ConnectArgs(
    public val protocol: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayDefaultRouteTableAssociation: Output<Boolean>? = null,
    public val transitGatewayDefaultRouteTablePropagation: Output<Boolean>? = null,
    public val transitGatewayId: Output<String>? = null,
    public val transportAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.ConnectArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.ConnectArgs =
        com.pulumi.aws.ec2transitgateway.ConnectArgs.builder()
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayDefaultRouteTableAssociation(
                transitGatewayDefaultRouteTableAssociation?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitGatewayDefaultRouteTablePropagation(
                transitGatewayDefaultRouteTablePropagation?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 }))
            .transportAttachmentId(transportAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectArgs].
 */
@PulumiTagMarker
public class ConnectArgsBuilder internal constructor() {
    private var protocol: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayDefaultRouteTableAssociation: Output<Boolean>? = null

    private var transitGatewayDefaultRouteTablePropagation: Output<Boolean>? = null

    private var transitGatewayId: Output<String>? = null

    private var transportAttachmentId: Output<String>? = null

    /**
     * @param value The tunnel protocol. Valid values: `gre`. Default is `gre`.
     */
    @JvmName("uckkuwfofhumgyrg")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bbxausmuyjvxslky")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Boolean whether the Connect should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("cmxsklcdernopqxu")
    public suspend fun transitGatewayDefaultRouteTableAssociation(`value`: Output<Boolean>) {
        this.transitGatewayDefaultRouteTableAssociation = value
    }

    /**
     * @param value Boolean whether the Connect should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("ctjbgsuuattitnuw")
    public suspend fun transitGatewayDefaultRouteTablePropagation(`value`: Output<Boolean>) {
        this.transitGatewayDefaultRouteTablePropagation = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("iqbxdxbtgmitnwpd")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value The underlaying VPC attachment
     */
    @JvmName("kqbpmocgwfwhwhbs")
    public suspend fun transportAttachmentId(`value`: Output<String>) {
        this.transportAttachmentId = value
    }

    /**
     * @param value The tunnel protocol. Valid values: `gre`. Default is `gre`.
     */
    @JvmName("ymstxdlqtiemwflf")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mvinvgwcntjcekwg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ecdxjgyuatrhhgig")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Boolean whether the Connect should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("vodbgtioambwhkuq")
    public suspend fun transitGatewayDefaultRouteTableAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayDefaultRouteTableAssociation = mapped
    }

    /**
     * @param value Boolean whether the Connect should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("cmgbvwtwojfkdqjx")
    public suspend fun transitGatewayDefaultRouteTablePropagation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayDefaultRouteTablePropagation = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("hklcpcjgerbrhcck")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    /**
     * @param value The underlaying VPC attachment
     */
    @JvmName("okkhtqyvepeumybm")
    public suspend fun transportAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportAttachmentId = mapped
    }

    internal fun build(): ConnectArgs = ConnectArgs(
        protocol = protocol,
        tags = tags,
        transitGatewayDefaultRouteTableAssociation = transitGatewayDefaultRouteTableAssociation,
        transitGatewayDefaultRouteTablePropagation = transitGatewayDefaultRouteTablePropagation,
        transitGatewayId = transitGatewayId,
        transportAttachmentId = transportAttachmentId,
    )
}
