@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ConnectPeer].
 */
@PulumiTagMarker
public class ConnectPeerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectPeerArgs = ConnectPeerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectPeerArgsBuilder.() -> Unit) {
        val builder = ConnectPeerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectPeer {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.ConnectPeer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectPeer(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Connect Peer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Connect;
 * import com.pulumi.aws.ec2transitgateway.ConnectArgs;
 * import com.pulumi.aws.ec2transitgateway.ConnectPeer;
 * import com.pulumi.aws.ec2transitgateway.ConnectPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConnect = new Connect("exampleConnect", ConnectArgs.builder()
 *             .transportAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .peerAddress("10.1.2.3")
 *             .insideCidrBlocks("169.254.100.0/29")
 *             .transitGatewayAttachmentId(exampleConnect.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_connect_peer` using the EC2 Transit Gateway Connect Peer identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/connectPeer:ConnectPeer example tgw-connect-peer-12345678
 * ```
 *
 */
public class ConnectPeer internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.ConnectPeer,
) : KotlinCustomResource(javaResource, ConnectPeerMapper) {
    /**
     * EC2 Transit Gateway Connect Peer ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     */
    public val bgpAsn: Output<String>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The IP address assigned to customer device, which is used as BGP IP address.
     */
    public val bgpPeerAddress: Output<String>
        get() = javaResource.bgpPeerAddress().applyValue({ args0 -> args0 })

    /**
     * The IP addresses assigned to Transit Gateway, which are used as BGP IP addresses.
     */
    public val bgpTransitGatewayAddresses: Output<List<String>>
        get() = javaResource.bgpTransitGatewayAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    public val insideCidrBlocks: Output<List<String>>
        get() = javaResource.insideCidrBlocks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     */
    public val peerAddress: Output<String>
        get() = javaResource.peerAddress().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     */
    public val transitGatewayAddress: Output<String>
        get() = javaResource.transitGatewayAddress().applyValue({ args0 -> args0 })

    /**
     * The Transit Gateway Connect
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })
}

public object ConnectPeerMapper : ResourceMapper<ConnectPeer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.ConnectPeer::class == javaResource::class

    override fun map(javaResource: Resource): ConnectPeer = ConnectPeer(
        javaResource as
            com.pulumi.aws.ec2transitgateway.ConnectPeer,
    )
}

/**
 * @see [ConnectPeer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectPeer].
 */
public suspend fun connectPeer(name: String, block: suspend ConnectPeerResourceBuilder.() -> Unit):
    ConnectPeer {
    val builder = ConnectPeerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectPeer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectPeer(name: String): ConnectPeer {
    val builder = ConnectPeerResourceBuilder()
    builder.name(name)
    return builder.build()
}
