@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.ConnectPeerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Connect Peer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Connect;
 * import com.pulumi.aws.ec2transitgateway.ConnectArgs;
 * import com.pulumi.aws.ec2transitgateway.ConnectPeer;
 * import com.pulumi.aws.ec2transitgateway.ConnectPeerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleConnect = new Connect("exampleConnect", ConnectArgs.builder()
 *             .transportAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .build());
 *         var exampleConnectPeer = new ConnectPeer("exampleConnectPeer", ConnectPeerArgs.builder()
 *             .peerAddress("10.1.2.3")
 *             .insideCidrBlocks("169.254.100.0/29")
 *             .transitGatewayAttachmentId(exampleConnect.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_connect_peer` using the EC2 Transit Gateway Connect Peer identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/connectPeer:ConnectPeer example tgw-connect-peer-12345678
 * ```
 * @property bgpAsn The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
 * @property insideCidrBlocks The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
 * @property peerAddress The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
 * @property tags Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayAddress The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
 * @property transitGatewayAttachmentId The Transit Gateway Connect
 */
public data class ConnectPeerArgs(
    public val bgpAsn: Output<String>? = null,
    public val insideCidrBlocks: Output<List<String>>? = null,
    public val peerAddress: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayAddress: Output<String>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.ConnectPeerArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.ConnectPeerArgs =
        com.pulumi.aws.ec2transitgateway.ConnectPeerArgs.builder()
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .insideCidrBlocks(insideCidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .peerAddress(peerAddress?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayAddress(transitGatewayAddress?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectPeerArgs].
 */
@PulumiTagMarker
public class ConnectPeerArgsBuilder internal constructor() {
    private var bgpAsn: Output<String>? = null

    private var insideCidrBlocks: Output<List<String>>? = null

    private var peerAddress: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayAddress: Output<String>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    /**
     * @param value The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     */
    @JvmName("xayopelpivniqfwe")
    public suspend fun bgpAsn(`value`: Output<String>) {
        this.bgpAsn = value
    }

    /**
     * @param value The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("tpcxnkjrwlchrocr")
    public suspend fun insideCidrBlocks(`value`: Output<List<String>>) {
        this.insideCidrBlocks = value
    }

    @JvmName("apklfpdqneepmkum")
    public suspend fun insideCidrBlocks(vararg values: Output<String>) {
        this.insideCidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("iiphnsbmpdyjtjgb")
    public suspend fun insideCidrBlocks(values: List<Output<String>>) {
        this.insideCidrBlocks = Output.all(values)
    }

    /**
     * @param value The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     */
    @JvmName("ftanuihlxlihcqgg")
    public suspend fun peerAddress(`value`: Output<String>) {
        this.peerAddress = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dassbbxkcowikfua")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     */
    @JvmName("wkahiwtqjhgmyuat")
    public suspend fun transitGatewayAddress(`value`: Output<String>) {
        this.transitGatewayAddress = value
    }

    /**
     * @param value The Transit Gateway Connect
     */
    @JvmName("xlpcfsvgldmdqbvt")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value The BGP ASN number assigned customer device. If not provided, it will use the same BGP ASN as is associated with Transit Gateway.
     */
    @JvmName("aewschqhewxlymmg")
    public suspend fun bgpAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("udmyivujqgtywhft")
    public suspend fun insideCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param values The CIDR block that will be used for addressing within the tunnel. It must contain exactly one IPv4 CIDR block and up to one IPv6 CIDR block. The IPv4 CIDR block must be /29 size and must be within 169.254.0.0/16 range, with exception of: 169.254.0.0/29, 169.254.1.0/29, 169.254.2.0/29, 169.254.3.0/29, 169.254.4.0/29, 169.254.5.0/29, 169.254.169.248/29. The IPv6 CIDR block must be /125 size and must be within fd00::/8. The first IP from each CIDR block is assigned for customer gateway, the second and third is for Transit Gateway (An example: from range 169.254.100.0/29, .1 is assigned to customer gateway and .2 and .3 are assigned to Transit Gateway)
     */
    @JvmName("cjssaewfqninnufd")
    public suspend fun insideCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param value The IP addressed assigned to customer device, which will be used as tunnel endpoint. It can be IPv4 or IPv6 address, but must be the same address family as `transit_gateway_address`
     */
    @JvmName("jouqkjmrdwvyfkgh")
    public suspend fun peerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAddress = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("henubtrrkntmvljm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Connect Peer. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uviwbhlfvhntwcpf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The IP address assigned to Transit Gateway, which will be used as tunnel endpoint. This address must be from associated Transit Gateway CIDR block. The address must be from the same address family as `peer_address`. If not set explicitly, it will be selected from associated Transit Gateway CIDR blocks
     */
    @JvmName("fdphwhqiulfatayo")
    public suspend fun transitGatewayAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAddress = mapped
    }

    /**
     * @param value The Transit Gateway Connect
     */
    @JvmName("pfsmgiypqkpuseqi")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    internal fun build(): ConnectPeerArgs = ConnectPeerArgs(
        bgpAsn = bgpAsn,
        insideCidrBlocks = insideCidrBlocks,
        peerAddress = peerAddress,
        tags = tags,
        transitGatewayAddress = transitGatewayAddress,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
    )
}
