@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getAttachmentsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getConnectPeerPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getConnectPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getDirectConnectGatewayAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getMulticastDomainPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getPeeringAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTableAssociationsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTablePlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTablePropagationsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getRouteTableRoutesPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getTransitGatewayPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getVpcAttachmentPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getVpcAttachmentsPlain
import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions.getVpnAttachmentPlain
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetAttachmentsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPeerFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPeerPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPeerPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetConnectPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetDirectConnectGatewayAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetDirectConnectGatewayAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetDirectConnectGatewayAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetMulticastDomainFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetMulticastDomainPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetMulticastDomainPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetPeeringAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableAssociationsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableAssociationsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableAssociationsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePropagationsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePropagationsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTablePropagationsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableRoutesFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableRoutesPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetRouteTableRoutesPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetTransitGatewayFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetTransitGatewayPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetTransitGatewayPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentsFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentsPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpcAttachmentsPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpnAttachmentFilter
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpnAttachmentPlainArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.GetVpnAttachmentPlainArgsBuilder
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectPeerResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetDirectConnectGatewayAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableAssociationsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTablePropagationsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableRoutesResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetTransitGatewayResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentsResult
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpnAttachmentResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentResult.Companion.toKotlin as getAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentsResult.Companion.toKotlin as getAttachmentsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectPeerResult.Companion.toKotlin as getConnectPeerResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectResult.Companion.toKotlin as getConnectResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetDirectConnectGatewayAttachmentResult.Companion.toKotlin as getDirectConnectGatewayAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainResult.Companion.toKotlin as getMulticastDomainResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentResult.Companion.toKotlin as getPeeringAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableAssociationsResult.Companion.toKotlin as getRouteTableAssociationsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTablePropagationsResult.Companion.toKotlin as getRouteTablePropagationsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableResult.Companion.toKotlin as getRouteTableResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableRoutesResult.Companion.toKotlin as getRouteTableRoutesResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetTransitGatewayResult.Companion.toKotlin as getTransitGatewayResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentResult.Companion.toKotlin as getVpcAttachmentResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpcAttachmentsResult.Companion.toKotlin as getVpcAttachmentsResultToKotlin
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetVpnAttachmentResult.Companion.toKotlin as getVpnAttachmentResultToKotlin

public object Ec2transitgatewayFunctions {
    /**
     * Get information on an EC2 Transit Gateway's attachment to a resource.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getAttachment(GetAttachmentArgs.builder()
     *             .filters(
     *                 GetAttachmentFilterArgs.builder()
     *                     .name("transit-gateway-id")
     *                     .values(aws_ec2_transit_gateway.example().id())
     *                     .build(),
     *                 GetAttachmentFilterArgs.builder()
     *                     .name("resource-type")
     *                     .values("peering")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAttachment.
     * @return A collection of values returned by getAttachment.
     */
    public suspend fun getAttachment(argument: GetAttachmentPlainArgs): GetAttachmentResult =
        getAttachmentResultToKotlin(getAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getAttachment].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the attachment.
     * @param transitGatewayAttachmentId ID of the attachment.
     * @return A collection of values returned by getAttachment.
     */
    public suspend fun getAttachment(
        filters: List<GetAttachmentFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayAttachmentId: String? = null,
    ): GetAttachmentResult {
        val argument = GetAttachmentPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayAttachmentId = transitGatewayAttachmentId,
        )
        return getAttachmentResultToKotlin(getAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetAttachmentPlainArgs].
     * @return A collection of values returned by getAttachment.
     */
    public suspend fun getAttachment(argument: suspend GetAttachmentPlainArgsBuilder.() -> Unit):
        GetAttachmentResult {
        val builder = GetAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachmentResultToKotlin(getAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on EC2 Transit Gateway Attachments.
     * {{% examples %}}
     * ## Example Usage
     * {{% /examples %}}
     * @param argument A collection of arguments for invoking getAttachments.
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(argument: GetAttachmentsPlainArgs): GetAttachmentsResult =
        getAttachmentsResultToKotlin(getAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getAttachments].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(
        filters: List<GetAttachmentsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetAttachmentsResult {
        val argument = GetAttachmentsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getAttachmentsResultToKotlin(getAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetAttachmentsPlainArgs].
     * @return A collection of values returned by getAttachments.
     */
    public suspend fun getAttachments(argument: suspend GetAttachmentsPlainArgsBuilder.() -> Unit):
        GetAttachmentsResult {
        val builder = GetAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachmentsResultToKotlin(getAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Connect.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnect(GetConnectArgs.builder()
     *             .filters(GetConnectFilterArgs.builder()
     *                 .name("transport-transit-gateway-attachment-id")
     *                 .values("tgw-attach-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnect(GetConnectArgs.builder()
     *             .transitGatewayConnectId("tgw-attach-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnect.
     * @return A collection of values returned by getConnect.
     */
    public suspend fun getConnect(argument: GetConnectPlainArgs): GetConnectResult =
        getConnectResultToKotlin(getConnectPlain(argument.toJava()).await())

    /**
     * @see [getConnect].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the EC2 Transit Gateway Connect
     * @param transitGatewayConnectId Identifier of the EC2 Transit Gateway Connect.
     * @return A collection of values returned by getConnect.
     */
    public suspend fun getConnect(
        filters: List<GetConnectFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayConnectId: String? = null,
    ): GetConnectResult {
        val argument = GetConnectPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayConnectId = transitGatewayConnectId,
        )
        return getConnectResultToKotlin(getConnectPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnect].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetConnectPlainArgs].
     * @return A collection of values returned by getConnect.
     */
    public suspend fun getConnect(argument: suspend GetConnectPlainArgsBuilder.() -> Unit):
        GetConnectResult {
        val builder = GetConnectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectResultToKotlin(getConnectPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Connect Peer.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnectPeer(GetConnectPeerArgs.builder()
     *             .filters(GetConnectPeerFilterArgs.builder()
     *                 .name("transit-gateway-attachment-id")
     *                 .values("tgw-attach-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getConnectPeer(GetConnectPeerArgs.builder()
     *             .transitGatewayConnectPeerId("tgw-connect-peer-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnectPeer.
     * @return A collection of values returned by getConnectPeer.
     */
    public suspend fun getConnectPeer(argument: GetConnectPeerPlainArgs): GetConnectPeerResult =
        getConnectPeerResultToKotlin(getConnectPeerPlain(argument.toJava()).await())

    /**
     * @see [getConnectPeer].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the EC2 Transit Gateway Connect Peer
     * @param transitGatewayConnectPeerId Identifier of the EC2 Transit Gateway Connect Peer.
     * @return A collection of values returned by getConnectPeer.
     */
    public suspend fun getConnectPeer(
        filters: List<GetConnectPeerFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayConnectPeerId: String? = null,
    ): GetConnectPeerResult {
        val argument = GetConnectPeerPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayConnectPeerId = transitGatewayConnectPeerId,
        )
        return getConnectPeerResultToKotlin(getConnectPeerPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectPeer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetConnectPeerPlainArgs].
     * @return A collection of values returned by getConnectPeer.
     */
    public suspend fun getConnectPeer(argument: suspend GetConnectPeerPlainArgsBuilder.() -> Unit):
        GetConnectPeerResult {
        val builder = GetConnectPeerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectPeerResultToKotlin(getConnectPeerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway's attachment to a Direct Connect Gateway.
     * ## Example Usage
     * ### By Transit Gateway and Direct Connect Gateway Identifiers
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getDirectConnectGatewayAttachment(GetDirectConnectGatewayAttachmentArgs.builder()
     *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
     *             .dxGatewayId(aws_dx_gateway.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDirectConnectGatewayAttachment.
     * @return A collection of values returned by getDirectConnectGatewayAttachment.
     */
    public suspend
    fun getDirectConnectGatewayAttachment(argument: GetDirectConnectGatewayAttachmentPlainArgs):
        GetDirectConnectGatewayAttachmentResult =
        getDirectConnectGatewayAttachmentResultToKotlin(getDirectConnectGatewayAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getDirectConnectGatewayAttachment].
     * @param dxGatewayId Identifier of the Direct Connect Gateway.
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
     * @param transitGatewayId Identifier of the EC2 Transit Gateway.
     * @return A collection of values returned by getDirectConnectGatewayAttachment.
     */
    public suspend fun getDirectConnectGatewayAttachment(
        dxGatewayId: String? = null,
        filters: List<GetDirectConnectGatewayAttachmentFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayId: String? = null,
    ): GetDirectConnectGatewayAttachmentResult {
        val argument = GetDirectConnectGatewayAttachmentPlainArgs(
            dxGatewayId = dxGatewayId,
            filters = filters,
            tags = tags,
            transitGatewayId = transitGatewayId,
        )
        return getDirectConnectGatewayAttachmentResultToKotlin(getDirectConnectGatewayAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDirectConnectGatewayAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetDirectConnectGatewayAttachmentPlainArgs].
     * @return A collection of values returned by getDirectConnectGatewayAttachment.
     */
    public suspend
    fun getDirectConnectGatewayAttachment(argument: suspend GetDirectConnectGatewayAttachmentPlainArgsBuilder.() -> Unit):
        GetDirectConnectGatewayAttachmentResult {
        val builder = GetDirectConnectGatewayAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDirectConnectGatewayAttachmentResultToKotlin(getDirectConnectGatewayAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Multicast Domain.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getMulticastDomain(GetMulticastDomainArgs.builder()
     *             .filters(GetMulticastDomainFilterArgs.builder()
     *                 .name("transit-gateway-multicast-domain-id")
     *                 .values("tgw-mcast-domain-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getMulticastDomain(GetMulticastDomainArgs.builder()
     *             .transitGatewayMulticastDomainId("tgw-mcast-domain-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getMulticastDomain.
     * @return A collection of values returned by getMulticastDomain.
     */
    public suspend fun getMulticastDomain(argument: GetMulticastDomainPlainArgs):
        GetMulticastDomainResult =
        getMulticastDomainResultToKotlin(getMulticastDomainPlain(argument.toJava()).await())

    /**
     * @see [getMulticastDomain].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param tags Key-value tags for the EC2 Transit Gateway Multicast Domain.
     * @param transitGatewayMulticastDomainId Identifier of the EC2 Transit Gateway Multicast Domain.
     * @return A collection of values returned by getMulticastDomain.
     */
    public suspend fun getMulticastDomain(
        filters: List<GetMulticastDomainFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayMulticastDomainId: String? = null,
    ): GetMulticastDomainResult {
        val argument = GetMulticastDomainPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
        )
        return getMulticastDomainResultToKotlin(getMulticastDomainPlain(argument.toJava()).await())
    }

    /**
     * @see [getMulticastDomain].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetMulticastDomainPlainArgs].
     * @return A collection of values returned by getMulticastDomain.
     */
    public suspend
    fun getMulticastDomain(argument: suspend GetMulticastDomainPlainArgsBuilder.() -> Unit):
        GetMulticastDomainResult {
        val builder = GetMulticastDomainPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMulticastDomainResultToKotlin(getMulticastDomainPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Peering Attachment.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getPeeringAttachment(GetPeeringAttachmentArgs.builder()
     *             .filters(GetPeeringAttachmentFilterArgs.builder()
     *                 .name("transit-gateway-attachment-id")
     *                 .values("tgw-attach-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetPeeringAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var attachment = Ec2transitgatewayFunctions.getPeeringAttachment(GetPeeringAttachmentArgs.builder()
     *             .id("tgw-attach-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPeeringAttachment.
     * @return A collection of values returned by getPeeringAttachment.
     */
    public suspend fun getPeeringAttachment(argument: GetPeeringAttachmentPlainArgs):
        GetPeeringAttachmentResult =
        getPeeringAttachmentResultToKotlin(getPeeringAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getPeeringAttachment].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway Peering Attachment.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the specific EC2 Transit Gateway Peering Attachment to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getPeeringAttachment.
     */
    public suspend fun getPeeringAttachment(
        filters: List<GetPeeringAttachmentFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetPeeringAttachmentResult {
        val argument = GetPeeringAttachmentPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getPeeringAttachmentResultToKotlin(getPeeringAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeeringAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetPeeringAttachmentPlainArgs].
     * @return A collection of values returned by getPeeringAttachment.
     */
    public suspend
    fun getPeeringAttachment(argument: suspend GetPeeringAttachmentPlainArgsBuilder.() -> Unit):
        GetPeeringAttachmentResult {
        val builder = GetPeeringAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeeringAttachmentResultToKotlin(getPeeringAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway Route Table.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTable(GetRouteTableArgs.builder()
     *             .filters(
     *                 GetRouteTableFilterArgs.builder()
     *                     .name("default-association-route-table")
     *                     .values("true")
     *                     .build(),
     *                 GetRouteTableFilterArgs.builder()
     *                     .name("transit-gateway-id")
     *                     .values("tgw-12345678")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTable(GetRouteTableArgs.builder()
     *             .id("tgw-rtb-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRouteTable.
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: GetRouteTablePlainArgs): GetRouteTableResult =
        getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())

    /**
     * @see [getRouteTable].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway Route Table.
     * @param tags Key-value tags for the EC2 Transit Gateway Route Table
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(
        filters: List<GetRouteTableFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetRouteTableResult {
        val argument = GetRouteTablePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTablePlainArgs].
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: suspend GetRouteTablePlainArgsBuilder.() -> Unit):
        GetRouteTableResult {
        val builder = GetRouteTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableResultToKotlin(getRouteTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Transit Gateway Route Table Associations, such as their identifiers.
     * ## Example Usage
     * ### By Transit Gateway Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableAssociationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTableAssociations(GetRouteTableAssociationsArgs.builder()
     *             .transitGatewayRouteTableId(aws_ec2_transit_gateway_route_table.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRouteTableAssociations.
     * @return A collection of values returned by getRouteTableAssociations.
     */
    public suspend fun getRouteTableAssociations(argument: GetRouteTableAssociationsPlainArgs):
        GetRouteTableAssociationsResult =
        getRouteTableAssociationsResultToKotlin(getRouteTableAssociationsPlain(argument.toJava()).await())

    /**
     * @see [getRouteTableAssociations].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     * @return A collection of values returned by getRouteTableAssociations.
     */
    public suspend fun getRouteTableAssociations(
        filters: List<GetRouteTableAssociationsFilter>? =
            null,
        transitGatewayRouteTableId: String,
    ): GetRouteTableAssociationsResult {
        val argument = GetRouteTableAssociationsPlainArgs(
            filters = filters,
            transitGatewayRouteTableId = transitGatewayRouteTableId,
        )
        return getRouteTableAssociationsResultToKotlin(getRouteTableAssociationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTableAssociations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTableAssociationsPlainArgs].
     * @return A collection of values returned by getRouteTableAssociations.
     */
    public suspend
    fun getRouteTableAssociations(argument: suspend GetRouteTableAssociationsPlainArgsBuilder.() -> Unit):
        GetRouteTableAssociationsResult {
        val builder = GetRouteTableAssociationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableAssociationsResultToKotlin(getRouteTableAssociationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Transit Gateway Route Table Propagations, such as their identifiers.
     * ## Example Usage
     * ### By Transit Gateway Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePropagationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getRouteTablePropagations(GetRouteTablePropagationsArgs.builder()
     *             .transitGatewayRouteTableId(aws_ec2_transit_gateway_route_table.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRouteTablePropagations.
     * @return A collection of values returned by getRouteTablePropagations.
     */
    public suspend fun getRouteTablePropagations(argument: GetRouteTablePropagationsPlainArgs):
        GetRouteTablePropagationsResult =
        getRouteTablePropagationsResultToKotlin(getRouteTablePropagationsPlain(argument.toJava()).await())

    /**
     * @see [getRouteTablePropagations].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     * @return A collection of values returned by getRouteTablePropagations.
     */
    public suspend fun getRouteTablePropagations(
        filters: List<GetRouteTablePropagationsFilter>? =
            null,
        transitGatewayRouteTableId: String,
    ): GetRouteTablePropagationsResult {
        val argument = GetRouteTablePropagationsPlainArgs(
            filters = filters,
            transitGatewayRouteTableId = transitGatewayRouteTableId,
        )
        return getRouteTablePropagationsResultToKotlin(getRouteTablePropagationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTablePropagations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTablePropagationsPlainArgs].
     * @return A collection of values returned by getRouteTablePropagations.
     */
    public suspend
    fun getRouteTablePropagations(argument: suspend GetRouteTablePropagationsPlainArgsBuilder.() -> Unit):
        GetRouteTablePropagationsResult {
        val builder = GetRouteTablePropagationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTablePropagationsResultToKotlin(getRouteTablePropagationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides informations for routes of a specific transit gateway, such as state, type, cidr
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTableRoutesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2transitgatewayFunctions.getRouteTableRoutes(GetRouteTableRoutesArgs.builder()
     *             .filters(GetRouteTableRoutesFilterArgs.builder()
     *                 .name("type")
     *                 .values("propagated")
     *                 .build())
     *             .transitGatewayRouteTableId(aws_ec2_transit_gateway_route_table.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRouteTableRoutes.
     * @return A collection of values returned by getRouteTableRoutes.
     */
    public suspend fun getRouteTableRoutes(argument: GetRouteTableRoutesPlainArgs):
        GetRouteTableRoutesResult =
        getRouteTableRoutesResultToKotlin(getRouteTableRoutesPlain(argument.toJava()).await())

    /**
     * @see [getRouteTableRoutes].
     * @param filters Custom filter block as described below.
     * @param transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getRouteTableRoutes.
     */
    public suspend fun getRouteTableRoutes(
        filters: List<GetRouteTableRoutesFilter>,
        transitGatewayRouteTableId: String,
    ): GetRouteTableRoutesResult {
        val argument = GetRouteTableRoutesPlainArgs(
            filters = filters,
            transitGatewayRouteTableId = transitGatewayRouteTableId,
        )
        return getRouteTableRoutesResultToKotlin(getRouteTableRoutesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTableRoutes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetRouteTableRoutesPlainArgs].
     * @return A collection of values returned by getRouteTableRoutes.
     */
    public suspend
    fun getRouteTableRoutes(argument: suspend GetRouteTableRoutesPlainArgsBuilder.() -> Unit):
        GetRouteTableRoutesResult {
        val builder = GetRouteTableRoutesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableRoutesResultToKotlin(getRouteTableRoutesPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getTransitGateway(GetTransitGatewayArgs.builder()
     *             .filters(GetTransitGatewayFilterArgs.builder()
     *                 .name("options.amazon-side-asn")
     *                 .values("64512")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetTransitGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getTransitGateway(GetTransitGatewayArgs.builder()
     *             .id("tgw-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTransitGateway.
     * @return A collection of values returned by getTransitGateway.
     */
    public suspend fun getTransitGateway(argument: GetTransitGatewayPlainArgs):
        GetTransitGatewayResult =
        getTransitGatewayResultToKotlin(getTransitGatewayPlain(argument.toJava()).await())

    /**
     * @see [getTransitGateway].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway.
     * @param tags Key-value tags for the EC2 Transit Gateway
     * @return A collection of values returned by getTransitGateway.
     */
    public suspend fun getTransitGateway(
        filters: List<GetTransitGatewayFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetTransitGatewayResult {
        val argument = GetTransitGatewayPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getTransitGatewayResultToKotlin(getTransitGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetTransitGatewayPlainArgs].
     * @return A collection of values returned by getTransitGateway.
     */
    public suspend
    fun getTransitGateway(argument: suspend GetTransitGatewayPlainArgsBuilder.() -> Unit):
        GetTransitGatewayResult {
        val builder = GetTransitGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitGatewayResultToKotlin(getTransitGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway VPC Attachment.
     * ## Example Usage
     * ### By Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getVpcAttachment(GetVpcAttachmentArgs.builder()
     *             .filters(GetVpcAttachmentFilterArgs.builder()
     *                 .name("vpc-id")
     *                 .values("vpc-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### By Identifier
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpcAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getVpcAttachment(GetVpcAttachmentArgs.builder()
     *             .id("tgw-attach-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcAttachment.
     * @return A collection of values returned by getVpcAttachment.
     */
    public suspend fun getVpcAttachment(argument: GetVpcAttachmentPlainArgs): GetVpcAttachmentResult =
        getVpcAttachmentResultToKotlin(getVpcAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getVpcAttachment].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @param id Identifier of the EC2 Transit Gateway VPC Attachment.
     * @param tags Key-value tags for the EC2 Transit Gateway VPC Attachment
     * @return A collection of values returned by getVpcAttachment.
     */
    public suspend fun getVpcAttachment(
        filters: List<GetVpcAttachmentFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcAttachmentResult {
        val argument = GetVpcAttachmentPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getVpcAttachmentResultToKotlin(getVpcAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetVpcAttachmentPlainArgs].
     * @return A collection of values returned by getVpcAttachment.
     */
    public suspend
    fun getVpcAttachment(argument: suspend GetVpcAttachmentPlainArgsBuilder.() -> Unit):
        GetVpcAttachmentResult {
        val builder = GetVpcAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcAttachmentResultToKotlin(getVpcAttachmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on EC2 Transit Gateway VPC Attachments.
     * ## Example Usage
     * ### By Filter
     * No Java example available.
     * @param argument A collection of arguments for invoking getVpcAttachments.
     * @return A collection of values returned by getVpcAttachments.
     */
    public suspend fun getVpcAttachments(argument: GetVpcAttachmentsPlainArgs):
        GetVpcAttachmentsResult =
        getVpcAttachmentsResultToKotlin(getVpcAttachmentsPlain(argument.toJava()).await())

    /**
     * @see [getVpcAttachments].
     * @param filters One or more configuration blocks containing name-values filters. Detailed below.
     * @return A collection of values returned by getVpcAttachments.
     */
    public suspend fun getVpcAttachments(filters: List<GetVpcAttachmentsFilter>? = null):
        GetVpcAttachmentsResult {
        val argument = GetVpcAttachmentsPlainArgs(
            filters = filters,
        )
        return getVpcAttachmentsResultToKotlin(getVpcAttachmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcAttachments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetVpcAttachmentsPlainArgs].
     * @return A collection of values returned by getVpcAttachments.
     */
    public suspend
    fun getVpcAttachments(argument: suspend GetVpcAttachmentsPlainArgsBuilder.() -> Unit):
        GetVpcAttachmentsResult {
        val builder = GetVpcAttachmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcAttachmentsResultToKotlin(getVpcAttachmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information on an EC2 Transit Gateway VPN Attachment.
     * > EC2 Transit Gateway VPN Attachments are implicitly created by VPN Connections referencing an EC2 Transit Gateway so there is no managed resource. For ease, the `aws.ec2.VpnConnection` resource includes a `transit_gateway_attachment_id` attribute which can replace some usage of this data source. For tagging the attachment, see the `aws.ec2.Tag` resource.
     * ## Example Usage
     * ### By Transit Gateway and VPN Connection Identifiers
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2transitgatewayFunctions.getVpnAttachment(GetVpnAttachmentArgs.builder()
     *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
     *             .vpnConnectionId(aws_vpn_connection.example().id())
     *             .build());
     *     }
     * }
     * ```
     * ### Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2transitgateway.Ec2transitgatewayFunctions;
     * import com.pulumi.aws.ec2transitgateway.inputs.GetVpnAttachmentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2transitgatewayFunctions.getVpnAttachment(GetVpnAttachmentArgs.builder()
     *             .filters(GetVpnAttachmentFilterArgs.builder()
     *                 .name("resource-id")
     *                 .values("some-resource")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpnAttachment.
     * @return A collection of values returned by getVpnAttachment.
     */
    public suspend fun getVpnAttachment(argument: GetVpnAttachmentPlainArgs): GetVpnAttachmentResult =
        getVpnAttachmentResultToKotlin(getVpnAttachmentPlain(argument.toJava()).await())

    /**
     * @see [getVpnAttachment].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway VPN Attachment.
     * @param transitGatewayId Identifier of the EC2 Transit Gateway.
     * @param vpnConnectionId Identifier of the EC2 VPN Connection.
     * @return A collection of values returned by getVpnAttachment.
     */
    public suspend fun getVpnAttachment(
        filters: List<GetVpnAttachmentFilter>? = null,
        tags: Map<String, String>? = null,
        transitGatewayId: String? = null,
        vpnConnectionId: String? = null,
    ): GetVpnAttachmentResult {
        val argument = GetVpnAttachmentPlainArgs(
            filters = filters,
            tags = tags,
            transitGatewayId = transitGatewayId,
            vpnConnectionId = vpnConnectionId,
        )
        return getVpnAttachmentResultToKotlin(getVpnAttachmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpnAttachment].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2transitgateway&#46;kotlin&#46;inputs&#46;GetVpnAttachmentPlainArgs].
     * @return A collection of values returned by getVpnAttachment.
     */
    public suspend
    fun getVpnAttachment(argument: suspend GetVpnAttachmentPlainArgsBuilder.() -> Unit):
        GetVpnAttachmentResult {
        val builder = GetVpnAttachmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpnAttachmentResultToKotlin(getVpnAttachmentPlain(builtArgument.toJava()).await())
    }
}
