@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.kotlin.outputs.InstanceConnectEndpointTimeouts
import com.pulumi.aws.ec2transitgateway.kotlin.outputs.InstanceConnectEndpointTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [InstanceConnectEndpoint].
 */
@PulumiTagMarker
public class InstanceConnectEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceConnectEndpointArgs = InstanceConnectEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceConnectEndpointArgsBuilder.() -> Unit) {
        val builder = InstanceConnectEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceConnectEndpoint {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.InstanceConnectEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceConnectEndpoint(builtJavaResource)
    }
}

/**
 * Manages an EC2 Instance Connect Endpoint.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.InstanceConnectEndpoint;
 * import com.pulumi.aws.ec2transitgateway.InstanceConnectEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceConnectEndpoint("example", InstanceConnectEndpointArgs.builder()
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EC2 Instance Connect Endpoints using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/instanceConnectEndpoint:InstanceConnectEndpoint example eice-012345678
 * ```
 *
 */
public class InstanceConnectEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.InstanceConnectEndpoint,
) : KotlinCustomResource(javaResource, InstanceConnectEndpointMapper) {
    /**
     * The Amazon Resource Name (ARN) of the EC2 Instance Connect Endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone of the EC2 Instance Connect Endpoint.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The DNS name of the EC2 Instance Connect Endpoint.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * The DNS name of the EC2 Instance Connect FIPS Endpoint.
     */
    public val fipsDnsName: Output<String>
        get() = javaResource.fipsDnsName().applyValue({ args0 -> args0 })

    /**
     * The IDs of the ENIs that Amazon EC2 automatically created when creating the EC2 Instance Connect Endpoint.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the AWS account that created the EC2 Instance Connect Endpoint.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether your client's IP address is preserved as the source. Default: `true`.
     */
    public val preserveClientIp: Output<Boolean>
        get() = javaResource.preserveClientIp().applyValue({ args0 -> args0 })

    /**
     * One or more security groups to associate with the endpoint. If you don't specify a security group, the default security group for the VPC will be associated with the endpoint.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the subnet in which to create the EC2 Instance Connect Endpoint.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<InstanceConnectEndpointTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the VPC in which the EC2 Instance Connect Endpoint was created.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object InstanceConnectEndpointMapper : ResourceMapper<InstanceConnectEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.InstanceConnectEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): InstanceConnectEndpoint =
        InstanceConnectEndpoint(
            javaResource as
                com.pulumi.aws.ec2transitgateway.InstanceConnectEndpoint,
        )
}

/**
 * @see [InstanceConnectEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceConnectEndpoint].
 */
public suspend fun instanceConnectEndpoint(
    name: String,
    block: suspend InstanceConnectEndpointResourceBuilder.() -> Unit,
): InstanceConnectEndpoint {
    val builder = InstanceConnectEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceConnectEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceConnectEndpoint(name: String): InstanceConnectEndpoint {
    val builder = InstanceConnectEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
