@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.InstanceConnectEndpointArgs.builder
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.InstanceConnectEndpointTimeoutsArgs
import com.pulumi.aws.ec2transitgateway.kotlin.inputs.InstanceConnectEndpointTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Instance Connect Endpoint.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.InstanceConnectEndpoint;
 * import com.pulumi.aws.ec2transitgateway.InstanceConnectEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceConnectEndpoint("example", InstanceConnectEndpointArgs.builder()
 *             .subnetId(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EC2 Instance Connect Endpoints using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/instanceConnectEndpoint:InstanceConnectEndpoint example eice-012345678
 * ```
 * @property preserveClientIp Indicates whether your client's IP address is preserved as the source. Default: `true`.
 * @property securityGroupIds One or more security groups to associate with the endpoint. If you don't specify a security group, the default security group for the VPC will be associated with the endpoint.
 * @property subnetId The ID of the subnet in which to create the EC2 Instance Connect Endpoint.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class InstanceConnectEndpointArgs(
    public val preserveClientIp: Output<Boolean>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<InstanceConnectEndpointTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.InstanceConnectEndpointArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.InstanceConnectEndpointArgs =
        com.pulumi.aws.ec2transitgateway.InstanceConnectEndpointArgs.builder()
            .preserveClientIp(preserveClientIp?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InstanceConnectEndpointArgs].
 */
@PulumiTagMarker
public class InstanceConnectEndpointArgsBuilder internal constructor() {
    private var preserveClientIp: Output<Boolean>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<InstanceConnectEndpointTimeoutsArgs>? = null

    /**
     * @param value Indicates whether your client's IP address is preserved as the source. Default: `true`.
     */
    @JvmName("dqxjcevxbjbidpgo")
    public suspend fun preserveClientIp(`value`: Output<Boolean>) {
        this.preserveClientIp = value
    }

    /**
     * @param value One or more security groups to associate with the endpoint. If you don't specify a security group, the default security group for the VPC will be associated with the endpoint.
     */
    @JvmName("lfpiqiytgsqrpxxx")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("ehgdtgaegttosgpg")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values One or more security groups to associate with the endpoint. If you don't specify a security group, the default security group for the VPC will be associated with the endpoint.
     */
    @JvmName("cgeufcstxgyqaqml")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID of the subnet in which to create the EC2 Instance Connect Endpoint.
     */
    @JvmName("akoskmfkhpnttfxa")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yvjquesygbcvxcoi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("xouexcfiqdjypgxm")
    public suspend fun timeouts(`value`: Output<InstanceConnectEndpointTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Indicates whether your client's IP address is preserved as the source. Default: `true`.
     */
    @JvmName("elesyvvsvbdufuaf")
    public suspend fun preserveClientIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveClientIp = mapped
    }

    /**
     * @param value One or more security groups to associate with the endpoint. If you don't specify a security group, the default security group for the VPC will be associated with the endpoint.
     */
    @JvmName("kbkgijovkxpfdnee")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values One or more security groups to associate with the endpoint. If you don't specify a security group, the default security group for the VPC will be associated with the endpoint.
     */
    @JvmName("ljbxqelterybvkpn")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID of the subnet in which to create the EC2 Instance Connect Endpoint.
     */
    @JvmName("efmeyhwscwgutjtc")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("btaxkgjdlptpmuti")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("riasoluwxiqnkroq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("hiuvuwbpbinvyeyb")
    public suspend fun timeouts(`value`: InstanceConnectEndpointTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gfcxnmwrnkubdexa")
    public suspend
    fun timeouts(argument: suspend InstanceConnectEndpointTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceConnectEndpointTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): InstanceConnectEndpointArgs = InstanceConnectEndpointArgs(
        preserveClientIp = preserveClientIp,
        securityGroupIds = securityGroupIds,
        subnetId = subnetId,
        tags = tags,
        timeouts = timeouts,
    )
}
