@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MulticastDomain].
 */
@PulumiTagMarker
public class MulticastDomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MulticastDomainArgs = MulticastDomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MulticastDomainArgsBuilder.() -> Unit) {
        val builder = MulticastDomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MulticastDomain {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.MulticastDomain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MulticastDomain(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Multicast Domain.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomain;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSource;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMember;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         final var amazonLinux = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("amzn-ami-hvm-*-x86_64-gp2")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("owner-alias")
 *                     .values("amazon")
 *                     .build())
 *             .build());
 *         var vpc1 = new Vpc("vpc1", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpc2 = new Vpc("vpc2", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var subnet1 = new Subnet("subnet1", SubnetArgs.builder()
 *             .vpcId(vpc1.id())
 *             .cidrBlock("10.0.1.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var subnet2 = new Subnet("subnet2", SubnetArgs.builder()
 *             .vpcId(vpc1.id())
 *             .cidrBlock("10.0.2.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .build());
 *         var subnet3 = new Subnet("subnet3", SubnetArgs.builder()
 *             .vpcId(vpc2.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var instance1 = new Instance("instance1", InstanceArgs.builder()
 *             .ami(amazonLinux.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .subnetId(subnet1.id())
 *             .build());
 *         var instance2 = new Instance("instance2", InstanceArgs.builder()
 *             .ami(amazonLinux.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .subnetId(subnet2.id())
 *             .build());
 *         var instance3 = new Instance("instance3", InstanceArgs.builder()
 *             .ami(amazonLinux.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .subnetId(subnet3.id())
 *             .build());
 *         var tgw = new TransitGateway("tgw", TransitGatewayArgs.builder()
 *             .multicastSupport("enable")
 *             .build());
 *         var attachment1 = new VpcAttachment("attachment1", VpcAttachmentArgs.builder()
 *             .subnetIds(
 *                 subnet1.id(),
 *                 subnet2.id())
 *             .transitGatewayId(tgw.id())
 *             .vpcId(vpc1.id())
 *             .build());
 *         var attachment2 = new VpcAttachment("attachment2", VpcAttachmentArgs.builder()
 *             .subnetIds(subnet3.id())
 *             .transitGatewayId(tgw.id())
 *             .vpcId(vpc2.id())
 *             .build());
 *         var domain = new MulticastDomain("domain", MulticastDomainArgs.builder()
 *             .transitGatewayId(tgw.id())
 *             .staticSourcesSupport("enable")
 *             .tags(Map.of("Name", "Transit_Gateway_Multicast_Domain_Example"))
 *             .build());
 *         var association3 = new MulticastDomainAssociation("association3", MulticastDomainAssociationArgs.builder()
 *             .subnetId(subnet3.id())
 *             .transitGatewayAttachmentId(attachment2.id())
 *             .transitGatewayMulticastDomainId(domain.id())
 *             .build());
 *         var source = new MulticastGroupSource("source", MulticastGroupSourceArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(instance3.primaryNetworkInterfaceId())
 *             .transitGatewayMulticastDomainId(association3.transitGatewayMulticastDomainId())
 *             .build());
 *         var association1 = new MulticastDomainAssociation("association1", MulticastDomainAssociationArgs.builder()
 *             .subnetId(subnet1.id())
 *             .transitGatewayAttachmentId(attachment1.id())
 *             .transitGatewayMulticastDomainId(domain.id())
 *             .build());
 *         var association2 = new MulticastDomainAssociation("association2", MulticastDomainAssociationArgs.builder()
 *             .subnetId(subnet2.id())
 *             .transitGatewayAttachmentId(attachment2.id())
 *             .transitGatewayMulticastDomainId(domain.id())
 *             .build());
 *         var member1 = new MulticastGroupMember("member1", MulticastGroupMemberArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(instance1.primaryNetworkInterfaceId())
 *             .transitGatewayMulticastDomainId(association1.transitGatewayMulticastDomainId())
 *             .build());
 *         var member2 = new MulticastGroupMember("member2", MulticastGroupMemberArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(instance2.primaryNetworkInterfaceId())
 *             .transitGatewayMulticastDomainId(association1.transitGatewayMulticastDomainId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_multicast_domain` using the EC2 Transit Gateway Multicast Domain identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/multicastDomain:MulticastDomain example tgw-mcast-domain-12345
 * ```
 *
 */
public class MulticastDomain internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.MulticastDomain,
) : KotlinCustomResource(javaResource, MulticastDomainMapper) {
    /**
     * EC2 Transit Gateway Multicast Domain Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically accept cross-account subnet associations that are associated with the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val autoAcceptSharedAssociations: Output<String>?
        get() = javaResource.autoAcceptSharedAssociations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable Internet Group Management Protocol (IGMP) version 2 for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val igmpv2Support: Output<String>?
        get() = javaResource.igmpv2Support().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the AWS account that owns the EC2 Transit Gateway Multicast Domain.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Whether to enable support for statically configuring multicast group sources for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val staticSourcesSupport: Output<String>?
        get() = javaResource.staticSourcesSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value tags for the EC2 Transit Gateway Multicast Domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * EC2 Transit Gateway identifier. The EC2 Transit Gateway must have `multicast_support` enabled.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })
}

public object MulticastDomainMapper : ResourceMapper<MulticastDomain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.MulticastDomain::class == javaResource::class

    override fun map(javaResource: Resource): MulticastDomain = MulticastDomain(
        javaResource as
            com.pulumi.aws.ec2transitgateway.MulticastDomain,
    )
}

/**
 * @see [MulticastDomain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MulticastDomain].
 */
public suspend fun multicastDomain(
    name: String,
    block: suspend MulticastDomainResourceBuilder.() -> Unit,
): MulticastDomain {
    val builder = MulticastDomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MulticastDomain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multicastDomain(name: String): MulticastDomain {
    val builder = MulticastDomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
