@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.MulticastDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Multicast Domain.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomain;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSource;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMember;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         final var amazonLinux = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("amzn-ami-hvm-*-x86_64-gp2")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("owner-alias")
 *                     .values("amazon")
 *                     .build())
 *             .build());
 *         var vpc1 = new Vpc("vpc1", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpc2 = new Vpc("vpc2", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var subnet1 = new Subnet("subnet1", SubnetArgs.builder()
 *             .vpcId(vpc1.id())
 *             .cidrBlock("10.0.1.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var subnet2 = new Subnet("subnet2", SubnetArgs.builder()
 *             .vpcId(vpc1.id())
 *             .cidrBlock("10.0.2.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .build());
 *         var subnet3 = new Subnet("subnet3", SubnetArgs.builder()
 *             .vpcId(vpc2.id())
 *             .cidrBlock("10.1.1.0/24")
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *         var instance1 = new Instance("instance1", InstanceArgs.builder()
 *             .ami(amazonLinux.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .subnetId(subnet1.id())
 *             .build());
 *         var instance2 = new Instance("instance2", InstanceArgs.builder()
 *             .ami(amazonLinux.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .subnetId(subnet2.id())
 *             .build());
 *         var instance3 = new Instance("instance3", InstanceArgs.builder()
 *             .ami(amazonLinux.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .subnetId(subnet3.id())
 *             .build());
 *         var tgw = new TransitGateway("tgw", TransitGatewayArgs.builder()
 *             .multicastSupport("enable")
 *             .build());
 *         var attachment1 = new VpcAttachment("attachment1", VpcAttachmentArgs.builder()
 *             .subnetIds(
 *                 subnet1.id(),
 *                 subnet2.id())
 *             .transitGatewayId(tgw.id())
 *             .vpcId(vpc1.id())
 *             .build());
 *         var attachment2 = new VpcAttachment("attachment2", VpcAttachmentArgs.builder()
 *             .subnetIds(subnet3.id())
 *             .transitGatewayId(tgw.id())
 *             .vpcId(vpc2.id())
 *             .build());
 *         var domain = new MulticastDomain("domain", MulticastDomainArgs.builder()
 *             .transitGatewayId(tgw.id())
 *             .staticSourcesSupport("enable")
 *             .tags(Map.of("Name", "Transit_Gateway_Multicast_Domain_Example"))
 *             .build());
 *         var association3 = new MulticastDomainAssociation("association3", MulticastDomainAssociationArgs.builder()
 *             .subnetId(subnet3.id())
 *             .transitGatewayAttachmentId(attachment2.id())
 *             .transitGatewayMulticastDomainId(domain.id())
 *             .build());
 *         var source = new MulticastGroupSource("source", MulticastGroupSourceArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(instance3.primaryNetworkInterfaceId())
 *             .transitGatewayMulticastDomainId(association3.transitGatewayMulticastDomainId())
 *             .build());
 *         var association1 = new MulticastDomainAssociation("association1", MulticastDomainAssociationArgs.builder()
 *             .subnetId(subnet1.id())
 *             .transitGatewayAttachmentId(attachment1.id())
 *             .transitGatewayMulticastDomainId(domain.id())
 *             .build());
 *         var association2 = new MulticastDomainAssociation("association2", MulticastDomainAssociationArgs.builder()
 *             .subnetId(subnet2.id())
 *             .transitGatewayAttachmentId(attachment2.id())
 *             .transitGatewayMulticastDomainId(domain.id())
 *             .build());
 *         var member1 = new MulticastGroupMember("member1", MulticastGroupMemberArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(instance1.primaryNetworkInterfaceId())
 *             .transitGatewayMulticastDomainId(association1.transitGatewayMulticastDomainId())
 *             .build());
 *         var member2 = new MulticastGroupMember("member2", MulticastGroupMemberArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(instance2.primaryNetworkInterfaceId())
 *             .transitGatewayMulticastDomainId(association1.transitGatewayMulticastDomainId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_multicast_domain` using the EC2 Transit Gateway Multicast Domain identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/multicastDomain:MulticastDomain example tgw-mcast-domain-12345
 * ```
 * @property autoAcceptSharedAssociations Whether to automatically accept cross-account subnet associations that are associated with the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property igmpv2Support Whether to enable Internet Group Management Protocol (IGMP) version 2 for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property staticSourcesSupport Whether to enable support for statically configuring multicast group sources for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property tags Key-value tags for the EC2 Transit Gateway Multicast Domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayId EC2 Transit Gateway identifier. The EC2 Transit Gateway must have `multicast_support` enabled.
 */
public data class MulticastDomainArgs(
    public val autoAcceptSharedAssociations: Output<String>? = null,
    public val igmpv2Support: Output<String>? = null,
    public val staticSourcesSupport: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.MulticastDomainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.MulticastDomainArgs =
        com.pulumi.aws.ec2transitgateway.MulticastDomainArgs.builder()
            .autoAcceptSharedAssociations(autoAcceptSharedAssociations?.applyValue({ args0 -> args0 }))
            .igmpv2Support(igmpv2Support?.applyValue({ args0 -> args0 }))
            .staticSourcesSupport(staticSourcesSupport?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MulticastDomainArgs].
 */
@PulumiTagMarker
public class MulticastDomainArgsBuilder internal constructor() {
    private var autoAcceptSharedAssociations: Output<String>? = null

    private var igmpv2Support: Output<String>? = null

    private var staticSourcesSupport: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayId: Output<String>? = null

    /**
     * @param value Whether to automatically accept cross-account subnet associations that are associated with the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("vpatuojonskupmxq")
    public suspend fun autoAcceptSharedAssociations(`value`: Output<String>) {
        this.autoAcceptSharedAssociations = value
    }

    /**
     * @param value Whether to enable Internet Group Management Protocol (IGMP) version 2 for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("gwlgcbvtbnojovly")
    public suspend fun igmpv2Support(`value`: Output<String>) {
        this.igmpv2Support = value
    }

    /**
     * @param value Whether to enable support for statically configuring multicast group sources for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("stjhlqgcdrlushcf")
    public suspend fun staticSourcesSupport(`value`: Output<String>) {
        this.staticSourcesSupport = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Multicast Domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rvnyolhegildnvwb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value EC2 Transit Gateway identifier. The EC2 Transit Gateway must have `multicast_support` enabled.
     */
    @JvmName("oxviaytisurpiayd")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Whether to automatically accept cross-account subnet associations that are associated with the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("qddabsrdsbnuunqw")
    public suspend fun autoAcceptSharedAssociations(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAcceptSharedAssociations = mapped
    }

    /**
     * @param value Whether to enable Internet Group Management Protocol (IGMP) version 2 for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("hvtxixdreukihokx")
    public suspend fun igmpv2Support(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.igmpv2Support = mapped
    }

    /**
     * @param value Whether to enable support for statically configuring multicast group sources for the EC2 Transit Gateway Multicast Domain. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("rjkrghsnmumqjpcj")
    public suspend fun staticSourcesSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticSourcesSupport = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Multicast Domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lvhvcnkuplvaaumu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Multicast Domain. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gsuuwumxulrtlplj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value EC2 Transit Gateway identifier. The EC2 Transit Gateway must have `multicast_support` enabled.
     */
    @JvmName("trwhcanlyfsebbfu")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    internal fun build(): MulticastDomainArgs = MulticastDomainArgs(
        autoAcceptSharedAssociations = autoAcceptSharedAssociations,
        igmpv2Support = igmpv2Support,
        staticSourcesSupport = staticSourcesSupport,
        tags = tags,
        transitGatewayId = transitGatewayId,
    )
}
