@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MulticastDomainAssociation].
 */
@PulumiTagMarker
public class MulticastDomainAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MulticastDomainAssociationArgs = MulticastDomainAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MulticastDomainAssociationArgsBuilder.() -> Unit) {
        val builder = MulticastDomainAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MulticastDomainAssociation {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MulticastDomainAssociation(builtJavaResource)
    }
}

/**
 * Associates the specified subnet and transit gateway attachment with the specified transit gateway multicast domain.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomain;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .multicastSupport("enable")
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .subnetIds(aws_subnet.example().id())
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *         var exampleMulticastDomain = new MulticastDomain("exampleMulticastDomain", MulticastDomainArgs.builder()
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .build());
 *         var exampleMulticastDomainAssociation = new MulticastDomainAssociation("exampleMulticastDomainAssociation", MulticastDomainAssociationArgs.builder()
 *             .subnetId(aws_subnet.example().id())
 *             .transitGatewayAttachmentId(exampleVpcAttachment.id())
 *             .transitGatewayMulticastDomainId(exampleMulticastDomain.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class MulticastDomainAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation,
) : KotlinCustomResource(javaResource, MulticastDomainAssociationMapper) {
    /**
     * The ID of the subnet to associate with the transit gateway multicast domain.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * The ID of the transit gateway attachment.
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })

    /**
     * The ID of the transit gateway multicast domain.
     */
    public val transitGatewayMulticastDomainId: Output<String>
        get() = javaResource.transitGatewayMulticastDomainId().applyValue({ args0 -> args0 })
}

public object MulticastDomainAssociationMapper : ResourceMapper<MulticastDomainAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation::class == javaResource::class

    override fun map(javaResource: Resource): MulticastDomainAssociation =
        MulticastDomainAssociation(
            javaResource as
                com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation,
        )
}

/**
 * @see [MulticastDomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MulticastDomainAssociation].
 */
public suspend fun multicastDomainAssociation(
    name: String,
    block: suspend MulticastDomainAssociationResourceBuilder.() -> Unit,
):
    MulticastDomainAssociation {
    val builder = MulticastDomainAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MulticastDomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multicastDomainAssociation(name: String): MulticastDomainAssociation {
    val builder = MulticastDomainAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
