@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates the specified subnet and transit gateway attachment with the specified transit gateway multicast domain.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomain;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainArgs;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociation;
 * import com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .multicastSupport("enable")
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .subnetIds(aws_subnet.example().id())
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *         var exampleMulticastDomain = new MulticastDomain("exampleMulticastDomain", MulticastDomainArgs.builder()
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .build());
 *         var exampleMulticastDomainAssociation = new MulticastDomainAssociation("exampleMulticastDomainAssociation", MulticastDomainAssociationArgs.builder()
 *             .subnetId(aws_subnet.example().id())
 *             .transitGatewayAttachmentId(exampleVpcAttachment.id())
 *             .transitGatewayMulticastDomainId(exampleMulticastDomain.id())
 *             .build());
 *     }
 * }
 * ```
 * @property subnetId The ID of the subnet to associate with the transit gateway multicast domain.
 * @property transitGatewayAttachmentId The ID of the transit gateway attachment.
 * @property transitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
 */
public data class MulticastDomainAssociationArgs(
    public val subnetId: Output<String>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayMulticastDomainId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs =
        com.pulumi.aws.ec2transitgateway.MulticastDomainAssociationArgs.builder()
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayMulticastDomainId(
                transitGatewayMulticastDomainId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MulticastDomainAssociationArgs].
 */
@PulumiTagMarker
public class MulticastDomainAssociationArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayMulticastDomainId: Output<String>? = null

    /**
     * @param value The ID of the subnet to associate with the transit gateway multicast domain.
     */
    @JvmName("sjjpywcrasflxwqh")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the transit gateway attachment.
     */
    @JvmName("pyguwpgkifrextyq")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("mvebbbaoyumkplsm")
    public suspend fun transitGatewayMulticastDomainId(`value`: Output<String>) {
        this.transitGatewayMulticastDomainId = value
    }

    /**
     * @param value The ID of the subnet to associate with the transit gateway multicast domain.
     */
    @JvmName("dipivjqgefsagxvp")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The ID of the transit gateway attachment.
     */
    @JvmName("clnobtuojfxwscls")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("fggetwkokhgowcye")
    public suspend fun transitGatewayMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayMulticastDomainId = mapped
    }

    internal fun build(): MulticastDomainAssociationArgs = MulticastDomainAssociationArgs(
        subnetId = subnetId,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
    )
}
