@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registers members (network interfaces) with the transit gateway multicast group.
 * A member is a network interface associated with a supported EC2 instance that receives multicast traffic.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMember;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MulticastGroupMember("example", MulticastGroupMemberArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(aws_network_interface.example().id())
 *             .transitGatewayMulticastDomainId(aws_ec2_transit_gateway_multicast_domain.example().id())
 *             .build());
 *     }
 * }
 * ```
 * @property groupIpAddress The IP address assigned to the transit gateway multicast group.
 * @property networkInterfaceId The group members' network interface ID to register with the transit gateway multicast group.
 * @property transitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
 */
public data class MulticastGroupMemberArgs(
    public val groupIpAddress: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val transitGatewayMulticastDomainId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs =
        com.pulumi.aws.ec2transitgateway.MulticastGroupMemberArgs.builder()
            .groupIpAddress(groupIpAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .transitGatewayMulticastDomainId(
                transitGatewayMulticastDomainId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MulticastGroupMemberArgs].
 */
@PulumiTagMarker
public class MulticastGroupMemberArgsBuilder internal constructor() {
    private var groupIpAddress: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var transitGatewayMulticastDomainId: Output<String>? = null

    /**
     * @param value The IP address assigned to the transit gateway multicast group.
     */
    @JvmName("lbemgcdbsnqyclss")
    public suspend fun groupIpAddress(`value`: Output<String>) {
        this.groupIpAddress = value
    }

    /**
     * @param value The group members' network interface ID to register with the transit gateway multicast group.
     */
    @JvmName("plvlhhnhbxwpfqlh")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("fouftcqcihycfnva")
    public suspend fun transitGatewayMulticastDomainId(`value`: Output<String>) {
        this.transitGatewayMulticastDomainId = value
    }

    /**
     * @param value The IP address assigned to the transit gateway multicast group.
     */
    @JvmName("lequiesioyddajir")
    public suspend fun groupIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIpAddress = mapped
    }

    /**
     * @param value The group members' network interface ID to register with the transit gateway multicast group.
     */
    @JvmName("wvsujkhvnwpyflqr")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("yelmowhggfcwetqw")
    public suspend fun transitGatewayMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayMulticastDomainId = mapped
    }

    internal fun build(): MulticastGroupMemberArgs = MulticastGroupMemberArgs(
        groupIpAddress = groupIpAddress,
        networkInterfaceId = networkInterfaceId,
        transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
    )
}
