@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registers sources (network interfaces) with the transit gateway multicast group.
 * A multicast source is a network interface attached to a supported instance that sends multicast traffic.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSource;
 * import com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new MulticastGroupSource("example", MulticastGroupSourceArgs.builder()
 *             .groupIpAddress("224.0.0.1")
 *             .networkInterfaceId(aws_network_interface.example().id())
 *             .transitGatewayMulticastDomainId(aws_ec2_transit_gateway_multicast_domain.example().id())
 *             .build());
 *     }
 * }
 * ```
 * @property groupIpAddress The IP address assigned to the transit gateway multicast group.
 * @property networkInterfaceId The group members' network interface ID to register with the transit gateway multicast group.
 * @property transitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
 */
public data class MulticastGroupSourceArgs(
    public val groupIpAddress: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val transitGatewayMulticastDomainId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs =
        com.pulumi.aws.ec2transitgateway.MulticastGroupSourceArgs.builder()
            .groupIpAddress(groupIpAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .transitGatewayMulticastDomainId(
                transitGatewayMulticastDomainId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [MulticastGroupSourceArgs].
 */
@PulumiTagMarker
public class MulticastGroupSourceArgsBuilder internal constructor() {
    private var groupIpAddress: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var transitGatewayMulticastDomainId: Output<String>? = null

    /**
     * @param value The IP address assigned to the transit gateway multicast group.
     */
    @JvmName("vcsddfpqbtaljdjv")
    public suspend fun groupIpAddress(`value`: Output<String>) {
        this.groupIpAddress = value
    }

    /**
     * @param value The group members' network interface ID to register with the transit gateway multicast group.
     */
    @JvmName("hmcuymnswrcpfnrr")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("pjtoijyngkvmnijs")
    public suspend fun transitGatewayMulticastDomainId(`value`: Output<String>) {
        this.transitGatewayMulticastDomainId = value
    }

    /**
     * @param value The IP address assigned to the transit gateway multicast group.
     */
    @JvmName("cujlarynmctcuhqu")
    public suspend fun groupIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIpAddress = mapped
    }

    /**
     * @param value The group members' network interface ID to register with the transit gateway multicast group.
     */
    @JvmName("cdsuwltwhhtunnhu")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The ID of the transit gateway multicast domain.
     */
    @JvmName("dyottuebpkrmfqra")
    public suspend fun transitGatewayMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayMulticastDomainId = mapped
    }

    internal fun build(): MulticastGroupSourceArgs = MulticastGroupSourceArgs(
        groupIpAddress = groupIpAddress,
        networkInterfaceId = networkInterfaceId,
        transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
    )
}
