@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PeeringAttachment].
 */
@PulumiTagMarker
public class PeeringAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeeringAttachmentArgs = PeeringAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeeringAttachmentArgsBuilder.() -> Unit) {
        val builder = PeeringAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PeeringAttachment {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.PeeringAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PeeringAttachment(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Peering Attachment.
 * For examples of custom route table association and propagation, see the [EC2 Transit Gateway Networking Examples Guide](https://docs.aws.amazon.com/vpc/latest/tgw/TGW_Scenarios.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachment;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var local = new Provider("local", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var peer = new Provider("peer", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         final var peerRegion = AwsFunctions.getRegion();
 *         var localTransitGateway = new TransitGateway("localTransitGateway", TransitGatewayArgs.builder()
 *             .tags(Map.of("Name", "Local TGW"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.local())
 *                 .build());
 *         var peerTransitGateway = new TransitGateway("peerTransitGateway", TransitGatewayArgs.builder()
 *             .tags(Map.of("Name", "Peer TGW"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.peer())
 *                 .build());
 *         var example = new PeeringAttachment("example", PeeringAttachmentArgs.builder()
 *             .peerAccountId(peerTransitGateway.ownerId())
 *             .peerRegion(peerRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *             .peerTransitGatewayId(peerTransitGateway.id())
 *             .transitGatewayId(localTransitGateway.id())
 *             .tags(Map.of("Name", "TGW Peering Requestor"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_peering_attachment` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/peeringAttachment:PeeringAttachment example tgw-attach-12345678
 * ```
 *
 */
public class PeeringAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.PeeringAttachment,
) : KotlinCustomResource(javaResource, PeeringAttachmentMapper) {
    /**
     * Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
     */
    public val peerAccountId: Output<String>
        get() = javaResource.peerAccountId().applyValue({ args0 -> args0 })

    /**
     * Region of EC2 Transit Gateway to peer with.
     */
    public val peerRegion: Output<String>
        get() = javaResource.peerRegion().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway to peer with.
     */
    public val peerTransitGatewayId: Output<String>
        get() = javaResource.peerTransitGatewayId().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Identifier of EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })
}

public object PeeringAttachmentMapper : ResourceMapper<PeeringAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.PeeringAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PeeringAttachment = PeeringAttachment(
        javaResource as
            com.pulumi.aws.ec2transitgateway.PeeringAttachment,
    )
}

/**
 * @see [PeeringAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeeringAttachment].
 */
public suspend fun peeringAttachment(
    name: String,
    block: suspend PeeringAttachmentResourceBuilder.() -> Unit,
): PeeringAttachment {
    val builder = PeeringAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeeringAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun peeringAttachment(name: String): PeeringAttachment {
    val builder = PeeringAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
