@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PeeringAttachmentAccepter].
 */
@PulumiTagMarker
public class PeeringAttachmentAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeeringAttachmentAccepterArgs = PeeringAttachmentAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeeringAttachmentAccepterArgsBuilder.() -> Unit) {
        val builder = PeeringAttachmentAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PeeringAttachmentAccepter {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PeeringAttachmentAccepter(builtJavaResource)
    }
}

/**
 * Manages the accepter's side of an EC2 Transit Gateway Peering Attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PeeringAttachmentAccepter("example", PeeringAttachmentAccepterArgs.builder()
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_peering_attachment.example().id())
 *             .tags(Map.of("Name", "Example cross-account attachment"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_peering_attachment_accepter` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/peeringAttachmentAccepter:PeeringAttachmentAccepter example tgw-attach-12345678
 * ```
 *
 */
public class PeeringAttachmentAccepter internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter,
) : KotlinCustomResource(javaResource, PeeringAttachmentAccepterMapper) {
    /**
     * Identifier of the AWS account that owns the EC2 TGW peering.
     */
    public val peerAccountId: Output<String>
        get() = javaResource.peerAccountId().applyValue({ args0 -> args0 })

    public val peerRegion: Output<String>
        get() = javaResource.peerRegion().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway to peer with.
     */
    public val peerTransitGatewayId: Output<String>
        get() = javaResource.peerTransitGatewayId().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the EC2 Transit Gateway Peering Attachment to manage.
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })
}

public object PeeringAttachmentAccepterMapper : ResourceMapper<PeeringAttachmentAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter::class == javaResource::class

    override fun map(javaResource: Resource): PeeringAttachmentAccepter =
        PeeringAttachmentAccepter(
            javaResource as
                com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter,
        )
}

/**
 * @see [PeeringAttachmentAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeeringAttachmentAccepter].
 */
public suspend fun peeringAttachmentAccepter(
    name: String,
    block: suspend PeeringAttachmentAccepterResourceBuilder.() -> Unit,
): PeeringAttachmentAccepter {
    val builder = PeeringAttachmentAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeeringAttachmentAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun peeringAttachmentAccepter(name: String): PeeringAttachmentAccepter {
    val builder = PeeringAttachmentAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
