@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages the accepter's side of an EC2 Transit Gateway Peering Attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepter;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PeeringAttachmentAccepter("example", PeeringAttachmentAccepterArgs.builder()
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_peering_attachment.example().id())
 *             .tags(Map.of("Name", "Example cross-account attachment"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_peering_attachment_accepter` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/peeringAttachmentAccepter:PeeringAttachmentAccepter example tgw-attach-12345678
 * ```
 * @property tags Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayAttachmentId The ID of the EC2 Transit Gateway Peering Attachment to manage.
 */
public data class PeeringAttachmentAccepterArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs =
        com.pulumi.aws.ec2transitgateway.PeeringAttachmentAccepterArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringAttachmentAccepterArgs].
 */
@PulumiTagMarker
public class PeeringAttachmentAccepterArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pcxkjknppmsbfdrp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the EC2 Transit Gateway Peering Attachment to manage.
     */
    @JvmName("ordtjadhfcssfvih")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bqwsdenvtncpxktk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sxfhpyrvbomflmjq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the EC2 Transit Gateway Peering Attachment to manage.
     */
    @JvmName("tjnxddawvochipdm")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    internal fun build(): PeeringAttachmentAccepterArgs = PeeringAttachmentAccepterArgs(
        tags = tags,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
    )
}
