@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Peering Attachment.
 * For examples of custom route table association and propagation, see the [EC2 Transit Gateway Networking Examples Guide](https://docs.aws.amazon.com/vpc/latest/tgw/TGW_Scenarios.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachment;
 * import com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var local = new Provider("local", ProviderArgs.builder()
 *             .region("us-east-1")
 *             .build());
 *         var peer = new Provider("peer", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         final var peerRegion = AwsFunctions.getRegion();
 *         var localTransitGateway = new TransitGateway("localTransitGateway", TransitGatewayArgs.builder()
 *             .tags(Map.of("Name", "Local TGW"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.local())
 *                 .build());
 *         var peerTransitGateway = new TransitGateway("peerTransitGateway", TransitGatewayArgs.builder()
 *             .tags(Map.of("Name", "Peer TGW"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.peer())
 *                 .build());
 *         var example = new PeeringAttachment("example", PeeringAttachmentArgs.builder()
 *             .peerAccountId(peerTransitGateway.ownerId())
 *             .peerRegion(peerRegion.applyValue(getRegionResult -> getRegionResult.name()))
 *             .peerTransitGatewayId(peerTransitGateway.id())
 *             .transitGatewayId(localTransitGateway.id())
 *             .tags(Map.of("Name", "TGW Peering Requestor"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_peering_attachment` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/peeringAttachment:PeeringAttachment example tgw-attach-12345678
 * ```
 * @property peerAccountId Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
 * @property peerRegion Region of EC2 Transit Gateway to peer with.
 * @property peerTransitGatewayId Identifier of EC2 Transit Gateway to peer with.
 * @property tags Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayId Identifier of EC2 Transit Gateway.
 */
public data class PeeringAttachmentArgs(
    public val peerAccountId: Output<String>? = null,
    public val peerRegion: Output<String>? = null,
    public val peerTransitGatewayId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs =
        com.pulumi.aws.ec2transitgateway.PeeringAttachmentArgs.builder()
            .peerAccountId(peerAccountId?.applyValue({ args0 -> args0 }))
            .peerRegion(peerRegion?.applyValue({ args0 -> args0 }))
            .peerTransitGatewayId(peerTransitGatewayId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringAttachmentArgs].
 */
@PulumiTagMarker
public class PeeringAttachmentArgsBuilder internal constructor() {
    private var peerAccountId: Output<String>? = null

    private var peerRegion: Output<String>? = null

    private var peerTransitGatewayId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayId: Output<String>? = null

    /**
     * @param value Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("ydodjrlgumiwheht")
    public suspend fun peerAccountId(`value`: Output<String>) {
        this.peerAccountId = value
    }

    /**
     * @param value Region of EC2 Transit Gateway to peer with.
     */
    @JvmName("ypcxllfiuwlfakyw")
    public suspend fun peerRegion(`value`: Output<String>) {
        this.peerRegion = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway to peer with.
     */
    @JvmName("reyffqqmeceskwec")
    public suspend fun peerTransitGatewayId(`value`: Output<String>) {
        this.peerTransitGatewayId = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jdmljidqnromtbre")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("nkqjxptecobbkdfi")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Account ID of EC2 Transit Gateway to peer with. Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("pbveqkucponchmxk")
    public suspend fun peerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAccountId = mapped
    }

    /**
     * @param value Region of EC2 Transit Gateway to peer with.
     */
    @JvmName("lmcgqlxrojpywfja")
    public suspend fun peerRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerRegion = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway to peer with.
     */
    @JvmName("cwgjtwqchbdhulst")
    public suspend fun peerTransitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerTransitGatewayId = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nwpjnfqbqayowwba")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Peering Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qdciktgtmsuauvig")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("atkwgdbctwsycbbl")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    internal fun build(): PeeringAttachmentArgs = PeeringAttachmentArgs(
        peerAccountId = peerAccountId,
        peerRegion = peerRegion,
        peerTransitGatewayId = peerTransitGatewayId,
        tags = tags,
        transitGatewayId = transitGatewayId,
    )
}
