@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PolicyTable].
 */
@PulumiTagMarker
public class PolicyTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyTableArgs = PolicyTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyTableArgsBuilder.() -> Unit) {
        val builder = PolicyTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyTable {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.PolicyTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PolicyTable(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Policy Table.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PolicyTable;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyTable("example", PolicyTableArgs.builder()
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .tags(Map.of("Name", "Example Policy Table"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_policy_table` using the EC2 Transit Gateway Policy Table identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/policyTable:PolicyTable example tgw-rtb-12345678
 * ```
 *
 */
public class PolicyTable internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.PolicyTable,
) : KotlinCustomResource(javaResource, PolicyTableMapper) {
    /**
     * EC2 Transit Gateway Policy Table Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The state of the EC2 Transit Gateway Policy Table.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the EC2 Transit Gateway Policy Table. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * EC2 Transit Gateway identifier.
     */
    public val transitGatewayId: Output<String>
        get() = javaResource.transitGatewayId().applyValue({ args0 -> args0 })
}

public object PolicyTableMapper : ResourceMapper<PolicyTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.PolicyTable::class == javaResource::class

    override fun map(javaResource: Resource): PolicyTable = PolicyTable(
        javaResource as
            com.pulumi.aws.ec2transitgateway.PolicyTable,
    )
}

/**
 * @see [PolicyTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyTable].
 */
public suspend fun policyTable(name: String, block: suspend PolicyTableResourceBuilder.() -> Unit):
    PolicyTable {
    val builder = PolicyTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyTable(name: String): PolicyTable {
    val builder = PolicyTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
