@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PolicyTableAssociation].
 */
@PulumiTagMarker
public class PolicyTableAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyTableAssociationArgs = PolicyTableAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyTableAssociationArgsBuilder.() -> Unit) {
        val builder = PolicyTableAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PolicyTableAssociation {
        val builtJavaResource =
            com.pulumi.aws.ec2transitgateway.PolicyTableAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyTableAssociation(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Policy Table association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableAssociation;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyTableAssociation("example", PolicyTableAssociationArgs.builder()
 *             .transitGatewayAttachmentId(aws_networkmanager_transit_gateway_peering.example().transit_gateway_peering_attachment_id())
 *             .transitGatewayPolicyTableId(aws_ec2_transit_gateway_policy_table.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_policy_table_association` using the EC2 Transit Gateway Policy Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/policyTableAssociation:PolicyTableAssociation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 *
 */
public class PolicyTableAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.PolicyTableAssociation,
) : KotlinCustomResource(javaResource, PolicyTableAssociationMapper) {
    /**
     * Identifier of the resource
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Type of the resource
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway Attachment.
     */
    public val transitGatewayAttachmentId: Output<String>
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway Policy Table.
     */
    public val transitGatewayPolicyTableId: Output<String>
        get() = javaResource.transitGatewayPolicyTableId().applyValue({ args0 -> args0 })
}

public object PolicyTableAssociationMapper : ResourceMapper<PolicyTableAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.PolicyTableAssociation::class == javaResource::class

    override fun map(javaResource: Resource): PolicyTableAssociation =
        PolicyTableAssociation(
            javaResource as
                com.pulumi.aws.ec2transitgateway.PolicyTableAssociation,
        )
}

/**
 * @see [PolicyTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyTableAssociation].
 */
public suspend fun policyTableAssociation(
    name: String,
    block: suspend PolicyTableAssociationResourceBuilder.() -> Unit,
): PolicyTableAssociation {
    val builder = PolicyTableAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyTableAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyTableAssociation(name: String): PolicyTableAssociation {
    val builder = PolicyTableAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
