@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Policy Table association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableAssociation;
 * import com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PolicyTableAssociation("example", PolicyTableAssociationArgs.builder()
 *             .transitGatewayAttachmentId(aws_networkmanager_transit_gateway_peering.example().transit_gateway_peering_attachment_id())
 *             .transitGatewayPolicyTableId(aws_ec2_transit_gateway_policy_table.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_policy_table_association` using the EC2 Transit Gateway Policy Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/policyTableAssociation:PolicyTableAssociation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment.
 * @property transitGatewayPolicyTableId Identifier of EC2 Transit Gateway Policy Table.
 */
public data class PolicyTableAssociationArgs(
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayPolicyTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs =
        com.pulumi.aws.ec2transitgateway.PolicyTableAssociationArgs.builder()
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayPolicyTableId(transitGatewayPolicyTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTableAssociationArgs].
 */
@PulumiTagMarker
public class PolicyTableAssociationArgsBuilder internal constructor() {
    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayPolicyTableId: Output<String>? = null

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("gomgfrbycjgedoqh")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Policy Table.
     */
    @JvmName("hepuwhxmmfmlqbso")
    public suspend fun transitGatewayPolicyTableId(`value`: Output<String>) {
        this.transitGatewayPolicyTableId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("ngaovmfjuuhobece")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Policy Table.
     */
    @JvmName("aluqkyccdsabrisa")
    public suspend fun transitGatewayPolicyTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayPolicyTableId = mapped
    }

    internal fun build(): PolicyTableAssociationArgs = PolicyTableAssociationArgs(
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayPolicyTableId = transitGatewayPolicyTableId,
    )
}
