@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Prefix List Reference.
 * ## Example Usage
 * ### Attachment Routing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReference;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PrefixListReference("example", PrefixListReferenceArgs.builder()
 *             .prefixListId(aws_ec2_managed_prefix_list.example().id())
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 *     }
 * }
 * ```
 * ### Blackhole Routing
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReference;
 * import com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PrefixListReference("example", PrefixListReferenceArgs.builder()
 *             .blackhole(true)
 *             .prefixListId(aws_ec2_managed_prefix_list.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_prefix_list_reference` using the EC2 Transit Gateway Route Table identifier and EC2 Prefix List identifier, separated by an underscore (`_`). For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/prefixListReference:PrefixListReference example tgw-rtb-12345678_pl-12345678
 * ```
 * @property blackhole Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
 * @property prefixListId Identifier of EC2 Prefix List.
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment.
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 * The following arguments are optional:
 */
public data class PrefixListReferenceArgs(
    public val blackhole: Output<Boolean>? = null,
    public val prefixListId: Output<String>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayRouteTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs =
        com.pulumi.aws.ec2transitgateway.PrefixListReferenceArgs.builder()
            .blackhole(blackhole?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrefixListReferenceArgs].
 */
@PulumiTagMarker
public class PrefixListReferenceArgsBuilder internal constructor() {
    private var blackhole: Output<Boolean>? = null

    private var prefixListId: Output<String>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayRouteTableId: Output<String>? = null

    /**
     * @param value Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
     */
    @JvmName("piuufjaocjkooxsv")
    public suspend fun blackhole(`value`: Output<Boolean>) {
        this.blackhole = value
    }

    /**
     * @param value Identifier of EC2 Prefix List.
     */
    @JvmName("gclwkyqcelmxppkf")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("bjkmwmxhlgftvxkg")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     */
    @JvmName("cwitlyramjdnirux")
    public suspend fun transitGatewayRouteTableId(`value`: Output<String>) {
        this.transitGatewayRouteTableId = value
    }

    /**
     * @param value Indicates whether to drop traffic that matches the Prefix List. Defaults to `false`.
     */
    @JvmName("nhqyfylufuuidqoa")
    public suspend fun blackhole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blackhole = mapped
    }

    /**
     * @param value Identifier of EC2 Prefix List.
     */
    @JvmName("pcaqapsvjggupcim")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("ouhmpdktlwdaxtxv")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     */
    @JvmName("vtthypequaxxnqpt")
    public suspend fun transitGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): PrefixListReferenceArgs = PrefixListReferenceArgs(
        blackhole = blackhole,
        prefixListId = prefixListId,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayRouteTableId = transitGatewayRouteTableId,
    )
}
