@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Route].
 */
@PulumiTagMarker
public class RouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteArgs = RouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteArgsBuilder.() -> Unit) {
        val builder = RouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Route {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.Route(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Route(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway Route.
 * ## Example Usage
 * ### Standard usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Route;
 * import com.pulumi.aws.ec2transitgateway.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Route("example", RouteArgs.builder()
 *             .destinationCidrBlock("0.0.0.0/0")
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 *     }
 * }
 * ```
 * ### Blackhole route
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Route;
 * import com.pulumi.aws.ec2transitgateway.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Route("example", RouteArgs.builder()
 *             .destinationCidrBlock("0.0.0.0/0")
 *             .blackhole(true)
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route` using the EC2 Transit Gateway Route Table, an underscore, and the destination. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/route:Route example tgw-rtb-12345678_0.0.0.0/0
 * ```
 *
 */
public class Route internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.Route,
) : KotlinCustomResource(javaResource, RouteMapper) {
    /**
     * Indicates whether to drop traffic that matches this route (default to `false`).
     */
    public val blackhole: Output<Boolean>?
        get() = javaResource.blackhole().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IPv4 or IPv6 RFC1924 CIDR used for destination matches. Routing decisions are based on the most specific match.
     */
    public val destinationCidrBlock: Output<String>
        get() = javaResource.destinationCidrBlock().applyValue({ args0 -> args0 })

    /**
     * Identifier of EC2 Transit Gateway Attachment (required if `blackhole` is set to false).
     */
    public val transitGatewayAttachmentId: Output<String>?
        get() = javaResource.transitGatewayAttachmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of EC2 Transit Gateway Route Table.
     */
    public val transitGatewayRouteTableId: Output<String>
        get() = javaResource.transitGatewayRouteTableId().applyValue({ args0 -> args0 })
}

public object RouteMapper : ResourceMapper<Route> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.Route::class == javaResource::class

    override fun map(javaResource: Resource): Route = Route(
        javaResource as
            com.pulumi.aws.ec2transitgateway.Route,
    )
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Route].
 */
public suspend fun route(name: String, block: suspend RouteResourceBuilder.() -> Unit): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Route].
 * @param name The _unique_ name of the resulting resource.
 */
public fun route(name: String): Route {
    val builder = RouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
