@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.RouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Route.
 * ## Example Usage
 * ### Standard usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Route;
 * import com.pulumi.aws.ec2transitgateway.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Route("example", RouteArgs.builder()
 *             .destinationCidrBlock("0.0.0.0/0")
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 *     }
 * }
 * ```
 * ### Blackhole route
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.Route;
 * import com.pulumi.aws.ec2transitgateway.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Route("example", RouteArgs.builder()
 *             .destinationCidrBlock("0.0.0.0/0")
 *             .blackhole(true)
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway.example().association_default_route_table_id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route` using the EC2 Transit Gateway Route Table, an underscore, and the destination. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/route:Route example tgw-rtb-12345678_0.0.0.0/0
 * ```
 * @property blackhole Indicates whether to drop traffic that matches this route (default to `false`).
 * @property destinationCidrBlock IPv4 or IPv6 RFC1924 CIDR used for destination matches. Routing decisions are based on the most specific match.
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment (required if `blackhole` is set to false).
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 */
public data class RouteArgs(
    public val blackhole: Output<Boolean>? = null,
    public val destinationCidrBlock: Output<String>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayRouteTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.RouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.RouteArgs =
        com.pulumi.aws.ec2transitgateway.RouteArgs.builder()
            .blackhole(blackhole?.applyValue({ args0 -> args0 }))
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var blackhole: Output<Boolean>? = null

    private var destinationCidrBlock: Output<String>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayRouteTableId: Output<String>? = null

    /**
     * @param value Indicates whether to drop traffic that matches this route (default to `false`).
     */
    @JvmName("pvwdvktjitjqtkio")
    public suspend fun blackhole(`value`: Output<Boolean>) {
        this.blackhole = value
    }

    /**
     * @param value IPv4 or IPv6 RFC1924 CIDR used for destination matches. Routing decisions are based on the most specific match.
     */
    @JvmName("lacffhyjscquyoxd")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment (required if `blackhole` is set to false).
     */
    @JvmName("fpylkpgewervyvnc")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("dkipydgxbqxuxjxc")
    public suspend fun transitGatewayRouteTableId(`value`: Output<String>) {
        this.transitGatewayRouteTableId = value
    }

    /**
     * @param value Indicates whether to drop traffic that matches this route (default to `false`).
     */
    @JvmName("mwcdbelqyikelnpy")
    public suspend fun blackhole(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blackhole = mapped
    }

    /**
     * @param value IPv4 or IPv6 RFC1924 CIDR used for destination matches. Routing decisions are based on the most specific match.
     */
    @JvmName("ysdjysklebswgdhn")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment (required if `blackhole` is set to false).
     */
    @JvmName("ffpiyefwgkovtcwr")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("xkxyaiqjrtgimgmh")
    public suspend fun transitGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        blackhole = blackhole,
        destinationCidrBlock = destinationCidrBlock,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayRouteTableId = transitGatewayRouteTableId,
    )
}
