@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Route Table association.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTableAssociation;
 * import com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTableAssociation("example", RouteTableAssociationArgs.builder()
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway_route_table.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table_association` using the EC2 Transit Gateway Route Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/routeTableAssociation:RouteTableAssociation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 * @property replaceExistingAssociation Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment.
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 */
public data class RouteTableAssociationArgs(
    public val replaceExistingAssociation: Output<Boolean>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayRouteTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs =
        com.pulumi.aws.ec2transitgateway.RouteTableAssociationArgs.builder()
            .replaceExistingAssociation(replaceExistingAssociation?.applyValue({ args0 -> args0 }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTableAssociationArgs].
 */
@PulumiTagMarker
public class RouteTableAssociationArgsBuilder internal constructor() {
    private var replaceExistingAssociation: Output<Boolean>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayRouteTableId: Output<String>? = null

    /**
     * @param value Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
     */
    @JvmName("gvboeicagplutvdl")
    public suspend fun replaceExistingAssociation(`value`: Output<Boolean>) {
        this.replaceExistingAssociation = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("wxhbqnnjtiqkrbsq")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("vhsolipsubboipfy")
    public suspend fun transitGatewayRouteTableId(`value`: Output<String>) {
        this.transitGatewayRouteTableId = value
    }

    /**
     * @param value Boolean whether the Gateway Attachment should remove any current Route Table association before associating with the specified Route Table. Default value: `false`. This argument is intended for use with EC2 Transit Gateways shared into the current account, otherwise the `transit_gateway_default_route_table_association` argument of the `aws.ec2transitgateway.VpcAttachment` resource should be used.
     */
    @JvmName("qsuesmxwjunmwngo")
    public suspend fun replaceExistingAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceExistingAssociation = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("liihryycpctxlqnl")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("skkwlomdkkgtjtio")
    public suspend fun transitGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): RouteTableAssociationArgs = RouteTableAssociationArgs(
        replaceExistingAssociation = replaceExistingAssociation,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayRouteTableId = transitGatewayRouteTableId,
    )
}
