@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.RouteTablePropagationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway Route Table propagation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.RouteTablePropagation;
 * import com.pulumi.aws.ec2transitgateway.RouteTablePropagationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RouteTablePropagation("example", RouteTablePropagationArgs.builder()
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .transitGatewayRouteTableId(aws_ec2_transit_gateway_route_table.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_route_table_propagation` using the EC2 Transit Gateway Route Table identifier, an underscore, and the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/routeTablePropagation:RouteTablePropagation example tgw-rtb-12345678_tgw-attach-87654321
 * ```
 * @property transitGatewayAttachmentId Identifier of EC2 Transit Gateway Attachment.
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 */
public data class RouteTablePropagationArgs(
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayRouteTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.RouteTablePropagationArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.RouteTablePropagationArgs =
        com.pulumi.aws.ec2transitgateway.RouteTablePropagationArgs.builder()
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteTablePropagationArgs].
 */
@PulumiTagMarker
public class RouteTablePropagationArgsBuilder internal constructor() {
    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayRouteTableId: Output<String>? = null

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("awktfosdcmwikedt")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("lfstagrshatqrkct")
    public suspend fun transitGatewayRouteTableId(`value`: Output<String>) {
        this.transitGatewayRouteTableId = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Attachment.
     */
    @JvmName("wmqqxguftkejfttb")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     */
    @JvmName("gbapkxvsgdpatble")
    public suspend fun transitGatewayRouteTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): RouteTablePropagationArgs = RouteTablePropagationArgs(
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayRouteTableId = transitGatewayRouteTableId,
    )
}
