@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [TransitGateway].
 */
@PulumiTagMarker
public class TransitGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitGatewayArgs = TransitGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitGatewayArgsBuilder.() -> Unit) {
        val builder = TransitGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TransitGateway {
        val builtJavaResource = com.pulumi.aws.ec2transitgateway.TransitGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TransitGateway(builtJavaResource)
    }
}

/**
 * Manages an EC2 Transit Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGateway("example", TransitGatewayArgs.builder()
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway` using the EC2 Transit Gateway identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/transitGateway:TransitGateway example tgw-12345678
 * ```
 *
 */
public class TransitGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2transitgateway.TransitGateway,
) : KotlinCustomResource(javaResource, TransitGatewayMapper) {
    /**
     * Private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is `64512` to `65534` for 16-bit ASNs and `4200000000` to `4294967294` for 32-bit ASNs. Default value: `64512`.
     * > **NOTE:** Modifying `amazon_side_asn` on a Transit Gateway with active BGP sessions is [not allowed](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayOptions.html). You must first delete all Transit Gateway attachments that have BGP configured prior to modifying `amazon_side_asn`.
     */
    public val amazonSideAsn: Output<Int>?
        get() = javaResource.amazonSideAsn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * EC2 Transit Gateway Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Identifier of the default association route table
     */
    public val associationDefaultRouteTableId: Output<String>
        get() = javaResource.associationDefaultRouteTableId().applyValue({ args0 -> args0 })

    /**
     * Whether resource attachment requests are automatically accepted. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val autoAcceptSharedAttachments: Output<String>?
        get() = javaResource.autoAcceptSharedAttachments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether resource attachments are automatically associated with the default association route table. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    public val defaultRouteTableAssociation: Output<String>?
        get() = javaResource.defaultRouteTableAssociation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether resource attachments automatically propagate routes to the default propagation route table. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    public val defaultRouteTablePropagation: Output<String>?
        get() = javaResource.defaultRouteTablePropagation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the EC2 Transit Gateway.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    public val dnsSupport: Output<String>?
        get() = javaResource.dnsSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether Multicast support is enabled. Required to use `ec2_transit_gateway_multicast_domain`. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    public val multicastSupport: Output<String>?
        get() = javaResource.multicastSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the AWS account that owns the EC2 Transit Gateway
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the default propagation route table
     */
    public val propagationDefaultRouteTableId: Output<String>
        get() = javaResource.propagationDefaultRouteTableId().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the EC2 Transit Gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    public val transitGatewayCidrBlocks: Output<List<String>>?
        get() = javaResource.transitGatewayCidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Whether VPN Equal Cost Multipath Protocol support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    public val vpnEcmpSupport: Output<String>?
        get() = javaResource.vpnEcmpSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TransitGatewayMapper : ResourceMapper<TransitGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2transitgateway.TransitGateway::class == javaResource::class

    override fun map(javaResource: Resource): TransitGateway = TransitGateway(
        javaResource as
            com.pulumi.aws.ec2transitgateway.TransitGateway,
    )
}

/**
 * @see [TransitGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitGateway].
 */
public suspend fun transitGateway(
    name: String,
    block: suspend TransitGatewayResourceBuilder.() -> Unit,
): TransitGateway {
    val builder = TransitGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitGateway(name: String): TransitGateway {
    val builder = TransitGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
