@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGateway("example", TransitGatewayArgs.builder()
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway` using the EC2 Transit Gateway identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/transitGateway:TransitGateway example tgw-12345678
 * ```
 * @property amazonSideAsn Private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is `64512` to `65534` for 16-bit ASNs and `4200000000` to `4294967294` for 32-bit ASNs. Default value: `64512`.
 * > **NOTE:** Modifying `amazon_side_asn` on a Transit Gateway with active BGP sessions is [not allowed](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayOptions.html). You must first delete all Transit Gateway attachments that have BGP configured prior to modifying `amazon_side_asn`.
 * @property autoAcceptSharedAttachments Whether resource attachment requests are automatically accepted. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property defaultRouteTableAssociation Whether resource attachments are automatically associated with the default association route table. Valid values: `disable`, `enable`. Default value: `enable`.
 * @property defaultRouteTablePropagation Whether resource attachments automatically propagate routes to the default propagation route table. Valid values: `disable`, `enable`. Default value: `enable`.
 * @property description Description of the EC2 Transit Gateway.
 * @property dnsSupport Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
 * @property multicastSupport Whether Multicast support is enabled. Required to use `ec2_transit_gateway_multicast_domain`. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property tags Key-value tags for the EC2 Transit Gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayCidrBlocks One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
 * @property vpnEcmpSupport Whether VPN Equal Cost Multipath Protocol support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
 */
public data class TransitGatewayArgs(
    public val amazonSideAsn: Output<Int>? = null,
    public val autoAcceptSharedAttachments: Output<String>? = null,
    public val defaultRouteTableAssociation: Output<String>? = null,
    public val defaultRouteTablePropagation: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dnsSupport: Output<String>? = null,
    public val multicastSupport: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayCidrBlocks: Output<List<String>>? = null,
    public val vpnEcmpSupport: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.TransitGatewayArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.TransitGatewayArgs =
        com.pulumi.aws.ec2transitgateway.TransitGatewayArgs.builder()
            .amazonSideAsn(amazonSideAsn?.applyValue({ args0 -> args0 }))
            .autoAcceptSharedAttachments(autoAcceptSharedAttachments?.applyValue({ args0 -> args0 }))
            .defaultRouteTableAssociation(defaultRouteTableAssociation?.applyValue({ args0 -> args0 }))
            .defaultRouteTablePropagation(defaultRouteTablePropagation?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dnsSupport(dnsSupport?.applyValue({ args0 -> args0 }))
            .multicastSupport(multicastSupport?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayCidrBlocks(
                transitGatewayCidrBlocks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .vpnEcmpSupport(vpnEcmpSupport?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitGatewayArgs].
 */
@PulumiTagMarker
public class TransitGatewayArgsBuilder internal constructor() {
    private var amazonSideAsn: Output<Int>? = null

    private var autoAcceptSharedAttachments: Output<String>? = null

    private var defaultRouteTableAssociation: Output<String>? = null

    private var defaultRouteTablePropagation: Output<String>? = null

    private var description: Output<String>? = null

    private var dnsSupport: Output<String>? = null

    private var multicastSupport: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayCidrBlocks: Output<List<String>>? = null

    private var vpnEcmpSupport: Output<String>? = null

    /**
     * @param value Private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is `64512` to `65534` for 16-bit ASNs and `4200000000` to `4294967294` for 32-bit ASNs. Default value: `64512`.
     * > **NOTE:** Modifying `amazon_side_asn` on a Transit Gateway with active BGP sessions is [not allowed](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayOptions.html). You must first delete all Transit Gateway attachments that have BGP configured prior to modifying `amazon_side_asn`.
     */
    @JvmName("bjyhcycljjlkgojf")
    public suspend fun amazonSideAsn(`value`: Output<Int>) {
        this.amazonSideAsn = value
    }

    /**
     * @param value Whether resource attachment requests are automatically accepted. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("cgawbeaiaxbrypso")
    public suspend fun autoAcceptSharedAttachments(`value`: Output<String>) {
        this.autoAcceptSharedAttachments = value
    }

    /**
     * @param value Whether resource attachments are automatically associated with the default association route table. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("ewwgbpfcjdxnpdsf")
    public suspend fun defaultRouteTableAssociation(`value`: Output<String>) {
        this.defaultRouteTableAssociation = value
    }

    /**
     * @param value Whether resource attachments automatically propagate routes to the default propagation route table. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("gegitcitlbiswmji")
    public suspend fun defaultRouteTablePropagation(`value`: Output<String>) {
        this.defaultRouteTablePropagation = value
    }

    /**
     * @param value Description of the EC2 Transit Gateway.
     */
    @JvmName("tyvqkidlgkjglkhw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("oexwtceopwyacimm")
    public suspend fun dnsSupport(`value`: Output<String>) {
        this.dnsSupport = value
    }

    /**
     * @param value Whether Multicast support is enabled. Required to use `ec2_transit_gateway_multicast_domain`. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("dabvunnhmwrsphpr")
    public suspend fun multicastSupport(`value`: Output<String>) {
        this.multicastSupport = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ieofylaemgfpyfdw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    @JvmName("uswvilfhyatoidlg")
    public suspend fun transitGatewayCidrBlocks(`value`: Output<List<String>>) {
        this.transitGatewayCidrBlocks = value
    }

    @JvmName("gtkcwyosnasavkpg")
    public suspend fun transitGatewayCidrBlocks(vararg values: Output<String>) {
        this.transitGatewayCidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    @JvmName("yjcjgfttmytjacyg")
    public suspend fun transitGatewayCidrBlocks(values: List<Output<String>>) {
        this.transitGatewayCidrBlocks = Output.all(values)
    }

    /**
     * @param value Whether VPN Equal Cost Multipath Protocol support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("bmrfsghklvygijkt")
    public suspend fun vpnEcmpSupport(`value`: Output<String>) {
        this.vpnEcmpSupport = value
    }

    /**
     * @param value Private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is `64512` to `65534` for 16-bit ASNs and `4200000000` to `4294967294` for 32-bit ASNs. Default value: `64512`.
     * > **NOTE:** Modifying `amazon_side_asn` on a Transit Gateway with active BGP sessions is [not allowed](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayOptions.html). You must first delete all Transit Gateway attachments that have BGP configured prior to modifying `amazon_side_asn`.
     */
    @JvmName("cykttudhhaqnokvs")
    public suspend fun amazonSideAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonSideAsn = mapped
    }

    /**
     * @param value Whether resource attachment requests are automatically accepted. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("trvotalnsfqbpegg")
    public suspend fun autoAcceptSharedAttachments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAcceptSharedAttachments = mapped
    }

    /**
     * @param value Whether resource attachments are automatically associated with the default association route table. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("ajaiusnbhpufdqat")
    public suspend fun defaultRouteTableAssociation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRouteTableAssociation = mapped
    }

    /**
     * @param value Whether resource attachments automatically propagate routes to the default propagation route table. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("ifvluvqmrlvfxaaq")
    public suspend fun defaultRouteTablePropagation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRouteTablePropagation = mapped
    }

    /**
     * @param value Description of the EC2 Transit Gateway.
     */
    @JvmName("eauplrseiocuswwy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("gokxopwpmxoignoe")
    public suspend fun dnsSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSupport = mapped
    }

    /**
     * @param value Whether Multicast support is enabled. Required to use `ec2_transit_gateway_multicast_domain`. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("llrpicssakoewiqk")
    public suspend fun multicastSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multicastSupport = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rtxjhruismaxndpw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kivflrxvrgggltcf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    @JvmName("fmclaldvykurqosj")
    public suspend fun transitGatewayCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayCidrBlocks = mapped
    }

    /**
     * @param values One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    @JvmName("rbcunohcbvqkknpf")
    public suspend fun transitGatewayCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitGatewayCidrBlocks = mapped
    }

    /**
     * @param value Whether VPN Equal Cost Multipath Protocol support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("tqehcvtxoqwtolsy")
    public suspend fun vpnEcmpSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnEcmpSupport = mapped
    }

    internal fun build(): TransitGatewayArgs = TransitGatewayArgs(
        amazonSideAsn = amazonSideAsn,
        autoAcceptSharedAttachments = autoAcceptSharedAttachments,
        defaultRouteTableAssociation = defaultRouteTableAssociation,
        defaultRouteTablePropagation = defaultRouteTablePropagation,
        description = description,
        dnsSupport = dnsSupport,
        multicastSupport = multicastSupport,
        tags = tags,
        transitGatewayCidrBlocks = transitGatewayCidrBlocks,
        vpnEcmpSupport = vpnEcmpSupport,
    )
}
