@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages the accepter's side of an EC2 Transit Gateway VPC Attachment.
 * When a cross-account (requester's AWS account differs from the accepter's AWS account) EC2 Transit Gateway VPC Attachment
 * is created, an EC2 Transit Gateway VPC Attachment resource is automatically created in the accepter's account.
 * The requester can use the `aws.ec2transitgateway.VpcAttachment` resource to manage its side of the connection
 * and the accepter can use the `aws.ec2transitgateway.VpcAttachmentAccepter` resource to "adopt" its side of the
 * connection into management.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepter;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachmentAccepter("example", VpcAttachmentAccepterArgs.builder()
 *             .transitGatewayAttachmentId(aws_ec2_transit_gateway_vpc_attachment.example().id())
 *             .tags(Map.of("Name", "Example cross-account attachment"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_vpc_attachment_accepter` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/vpcAttachmentAccepter:VpcAttachmentAccepter example tgw-attach-12345678
 * ```
 * @property tags Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayAttachmentId The ID of the EC2 Transit Gateway Attachment to manage.
 * @property transitGatewayDefaultRouteTableAssociation Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. Default value: `true`.
 * @property transitGatewayDefaultRouteTablePropagation Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. Default value: `true`.
 */
public data class VpcAttachmentAccepterArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayDefaultRouteTableAssociation: Output<Boolean>? = null,
    public val transitGatewayDefaultRouteTablePropagation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs =
        com.pulumi.aws.ec2transitgateway.VpcAttachmentAccepterArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
            .transitGatewayDefaultRouteTableAssociation(
                transitGatewayDefaultRouteTableAssociation?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitGatewayDefaultRouteTablePropagation(
                transitGatewayDefaultRouteTablePropagation?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VpcAttachmentAccepterArgs].
 */
@PulumiTagMarker
public class VpcAttachmentAccepterArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayDefaultRouteTableAssociation: Output<Boolean>? = null

    private var transitGatewayDefaultRouteTablePropagation: Output<Boolean>? = null

    /**
     * @param value Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cdnbkvvvrefaikjn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the EC2 Transit Gateway Attachment to manage.
     */
    @JvmName("bbqxlglwfgpndaip")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. Default value: `true`.
     */
    @JvmName("cftymnrkstmrivsm")
    public suspend fun transitGatewayDefaultRouteTableAssociation(`value`: Output<Boolean>) {
        this.transitGatewayDefaultRouteTableAssociation = value
    }

    /**
     * @param value Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. Default value: `true`.
     */
    @JvmName("iorydmqytmsuoxtk")
    public suspend fun transitGatewayDefaultRouteTablePropagation(`value`: Output<Boolean>) {
        this.transitGatewayDefaultRouteTablePropagation = value
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qsocryyyefebdiej")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tftutoysiepyqwck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the EC2 Transit Gateway Attachment to manage.
     */
    @JvmName("qbkdhhjhwtjxqite")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. Default value: `true`.
     */
    @JvmName("wgjhtjrtcubwwntk")
    public suspend fun transitGatewayDefaultRouteTableAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayDefaultRouteTableAssociation = mapped
    }

    /**
     * @param value Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. Default value: `true`.
     */
    @JvmName("uurgfsjuqcvygnmc")
    public suspend fun transitGatewayDefaultRouteTablePropagation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayDefaultRouteTablePropagation = mapped
    }

    internal fun build(): VpcAttachmentAccepterArgs = VpcAttachmentAccepterArgs(
        tags = tags,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayDefaultRouteTableAssociation = transitGatewayDefaultRouteTableAssociation,
        transitGatewayDefaultRouteTablePropagation = transitGatewayDefaultRouteTablePropagation,
    )
}
