@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin

import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EC2 Transit Gateway VPC Attachment. For examples of custom route table association and propagation, see the EC2 Transit Gateway Networking Examples Guide.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachment;
 * import com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetIds(aws_subnet.example().id())
 *             .transitGatewayId(aws_ec2_transit_gateway.example().id())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_transit_gateway_vpc_attachment` using the EC2 Transit Gateway Attachment identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2transitgateway/vpcAttachment:VpcAttachment example tgw-attach-12345678
 * ```
 * @property applianceModeSupport Whether Appliance Mode support is enabled. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property dnsSupport Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
 * @property ipv6Support Whether IPv6 support is enabled. Valid values: `disable`, `enable`. Default value: `disable`.
 * @property subnetIds Identifiers of EC2 Subnets.
 * @property tags Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayDefaultRouteTableAssociation Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
 * @property transitGatewayDefaultRouteTablePropagation Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
 * @property transitGatewayId Identifier of EC2 Transit Gateway.
 * @property vpcId Identifier of EC2 VPC.
 */
public data class VpcAttachmentArgs(
    public val applianceModeSupport: Output<String>? = null,
    public val dnsSupport: Output<String>? = null,
    public val ipv6Support: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayDefaultRouteTableAssociation: Output<Boolean>? = null,
    public val transitGatewayDefaultRouteTablePropagation: Output<Boolean>? = null,
    public val transitGatewayId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs =
        com.pulumi.aws.ec2transitgateway.VpcAttachmentArgs.builder()
            .applianceModeSupport(applianceModeSupport?.applyValue({ args0 -> args0 }))
            .dnsSupport(dnsSupport?.applyValue({ args0 -> args0 }))
            .ipv6Support(ipv6Support?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayDefaultRouteTableAssociation(
                transitGatewayDefaultRouteTableAssociation?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitGatewayDefaultRouteTablePropagation(
                transitGatewayDefaultRouteTablePropagation?.applyValue({ args0 ->
                    args0
                }),
            )
            .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcAttachmentArgs].
 */
@PulumiTagMarker
public class VpcAttachmentArgsBuilder internal constructor() {
    private var applianceModeSupport: Output<String>? = null

    private var dnsSupport: Output<String>? = null

    private var ipv6Support: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayDefaultRouteTableAssociation: Output<Boolean>? = null

    private var transitGatewayDefaultRouteTablePropagation: Output<Boolean>? = null

    private var transitGatewayId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Whether Appliance Mode support is enabled. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("mfyruimbpgrwvetw")
    public suspend fun applianceModeSupport(`value`: Output<String>) {
        this.applianceModeSupport = value
    }

    /**
     * @param value Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("yknbjyudmexoipsm")
    public suspend fun dnsSupport(`value`: Output<String>) {
        this.dnsSupport = value
    }

    /**
     * @param value Whether IPv6 support is enabled. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("veegtxhgudrrisfb")
    public suspend fun ipv6Support(`value`: Output<String>) {
        this.ipv6Support = value
    }

    /**
     * @param value Identifiers of EC2 Subnets.
     */
    @JvmName("kigdkgkubkadqblq")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("tkawwarexsjrucpt")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of EC2 Subnets.
     */
    @JvmName("rklkbixiliteewlf")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lbpjkijvewwpjsad")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("oeuleecbirxbhscj")
    public suspend fun transitGatewayDefaultRouteTableAssociation(`value`: Output<Boolean>) {
        this.transitGatewayDefaultRouteTableAssociation = value
    }

    /**
     * @param value Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("ljgyrkfdedvttbhv")
    public suspend fun transitGatewayDefaultRouteTablePropagation(`value`: Output<Boolean>) {
        this.transitGatewayDefaultRouteTablePropagation = value
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("bfjabstoubmnbrkt")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value Identifier of EC2 VPC.
     */
    @JvmName("fiqdplpdchvhpreg")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Whether Appliance Mode support is enabled. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("tytkgqjhsijytxpp")
    public suspend fun applianceModeSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceModeSupport = mapped
    }

    /**
     * @param value Whether DNS support is enabled. Valid values: `disable`, `enable`. Default value: `enable`.
     */
    @JvmName("gjyiniddruqkfdhi")
    public suspend fun dnsSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSupport = mapped
    }

    /**
     * @param value Whether IPv6 support is enabled. Valid values: `disable`, `enable`. Default value: `disable`.
     */
    @JvmName("jnujkdyuoywjpqdj")
    public suspend fun ipv6Support(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Support = mapped
    }

    /**
     * @param value Identifiers of EC2 Subnets.
     */
    @JvmName("dmukjnquyfkryspa")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Identifiers of EC2 Subnets.
     */
    @JvmName("bxjfxbbfhkqqmeds")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pffmgskpptohmxxs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway VPC Attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cbykdnknqavnpapx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Boolean whether the VPC Attachment should be associated with the EC2 Transit Gateway association default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("jjkkmosfqfvuxmvo")
    public suspend fun transitGatewayDefaultRouteTableAssociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayDefaultRouteTableAssociation = mapped
    }

    /**
     * @param value Boolean whether the VPC Attachment should propagate routes with the EC2 Transit Gateway propagation default route table. This cannot be configured or perform drift detection with Resource Access Manager shared EC2 Transit Gateways. Default value: `true`.
     */
    @JvmName("pwdaivolfptrqrhi")
    public suspend fun transitGatewayDefaultRouteTablePropagation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayDefaultRouteTablePropagation = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway.
     */
    @JvmName("cedibbyslybyhnwl")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    /**
     * @param value Identifier of EC2 VPC.
     */
    @JvmName("efpuxhfervdpjufe")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcAttachmentArgs = VpcAttachmentArgs(
        applianceModeSupport = applianceModeSupport,
        dnsSupport = dnsSupport,
        ipv6Support = ipv6Support,
        subnetIds = subnetIds,
        tags = tags,
        transitGatewayDefaultRouteTableAssociation = transitGatewayDefaultRouteTableAssociation,
        transitGatewayDefaultRouteTablePropagation = transitGatewayDefaultRouteTablePropagation,
        transitGatewayId = transitGatewayId,
        vpcId = vpcId,
    )
}
