@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnectPeer.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property tags Key-value tags for the EC2 Transit Gateway Connect Peer
 * @property transitGatewayConnectPeerId Identifier of the EC2 Transit Gateway Connect Peer.
 */
public data class GetConnectPeerPlainArgs(
    public val filters: List<GetConnectPeerFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val transitGatewayConnectPeerId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetConnectPeerPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayConnectPeerId(transitGatewayConnectPeerId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectPeerPlainArgs].
 */
@PulumiTagMarker
public class GetConnectPeerPlainArgsBuilder internal constructor() {
    private var filters: List<GetConnectPeerFilter>? = null

    private var tags: Map<String, String>? = null

    private var transitGatewayConnectPeerId: String? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("lymsjiqsyhnttwog")
    public suspend fun filters(`value`: List<GetConnectPeerFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("ovlevgjsbwvgjbcr")
    public suspend fun filters(argument: List<suspend GetConnectPeerFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetConnectPeerFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("exmmdnyurvgppblf")
    public suspend fun filters(vararg argument: suspend GetConnectPeerFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetConnectPeerFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("iyrhegyvujaehuld")
    public suspend fun filters(argument: suspend GetConnectPeerFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetConnectPeerFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("umauntcgilyeynmv")
    public suspend fun filters(vararg values: GetConnectPeerFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Connect Peer
     */
    @JvmName("cuikcsgkxvokmgmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Connect Peer
     */
    @JvmName("ohquivhwwgxcrwgd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway Connect Peer.
     */
    @JvmName("jgtmdmnwasomtwrh")
    public suspend fun transitGatewayConnectPeerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayConnectPeerId = mapped
    }

    internal fun build(): GetConnectPeerPlainArgs = GetConnectPeerPlainArgs(
        filters = filters,
        tags = tags,
        transitGatewayConnectPeerId = transitGatewayConnectPeerId,
    )
}
