@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDirectConnectGatewayAttachment.
 * @property dxGatewayId Identifier of the Direct Connect Gateway.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
 * @property transitGatewayId Identifier of the EC2 Transit Gateway.
 */
public data class GetDirectConnectGatewayAttachmentPlainArgs(
    public val dxGatewayId: String? = null,
    public val filters: List<GetDirectConnectGatewayAttachmentFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val transitGatewayId: String? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentPlainArgs> {
    override fun toJava():
        com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetDirectConnectGatewayAttachmentPlainArgs.builder()
            .dxGatewayId(dxGatewayId?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayId(transitGatewayId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDirectConnectGatewayAttachmentPlainArgs].
 */
@PulumiTagMarker
public class GetDirectConnectGatewayAttachmentPlainArgsBuilder internal constructor() {
    private var dxGatewayId: String? = null

    private var filters: List<GetDirectConnectGatewayAttachmentFilter>? = null

    private var tags: Map<String, String>? = null

    private var transitGatewayId: String? = null

    /**
     * @param value Identifier of the Direct Connect Gateway.
     */
    @JvmName("orssegrfaljldpmn")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dxGatewayId = mapped
    }

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ltiwgfonufrqhakp")
    public suspend fun filters(`value`: List<GetDirectConnectGatewayAttachmentFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("nwodramhqqdbglek")
    public suspend
    fun filters(argument: List<suspend GetDirectConnectGatewayAttachmentFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDirectConnectGatewayAttachmentFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("dmhycawsrgphvjdi")
    public suspend fun filters(
        vararg
        argument: suspend GetDirectConnectGatewayAttachmentFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetDirectConnectGatewayAttachmentFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wcxmynejysglmkgo")
    public suspend
    fun filters(argument: suspend GetDirectConnectGatewayAttachmentFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetDirectConnectGatewayAttachmentFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ctvbriiquaslhmtm")
    public suspend fun filters(vararg values: GetDirectConnectGatewayAttachmentFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
     */
    @JvmName("bpqhmfcoxhcpoxac")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired Transit Gateway Direct Connect Gateway Attachment.
     */
    @JvmName("wtgynucvwfhlkeml")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway.
     */
    @JvmName("yxboefrmboscphdj")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayId = mapped
    }

    internal fun build(): GetDirectConnectGatewayAttachmentPlainArgs =
        GetDirectConnectGatewayAttachmentPlainArgs(
            dxGatewayId = dxGatewayId,
            filters = filters,
            tags = tags,
            transitGatewayId = transitGatewayId,
        )
}
