@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMulticastDomain.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property tags Key-value tags for the EC2 Transit Gateway Multicast Domain.
 * @property transitGatewayMulticastDomainId Identifier of the EC2 Transit Gateway Multicast Domain.
 */
public data class GetMulticastDomainPlainArgs(
    public val filters: List<GetMulticastDomainFilter>? = null,
    public val tags: Map<String, String>? = null,
    public val transitGatewayMulticastDomainId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetMulticastDomainPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayMulticastDomainId(transitGatewayMulticastDomainId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMulticastDomainPlainArgs].
 */
@PulumiTagMarker
public class GetMulticastDomainPlainArgsBuilder internal constructor() {
    private var filters: List<GetMulticastDomainFilter>? = null

    private var tags: Map<String, String>? = null

    private var transitGatewayMulticastDomainId: String? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("blobqsntvhqtbfdv")
    public suspend fun filters(`value`: List<GetMulticastDomainFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("xibmjdimksnedsda")
    public suspend fun filters(argument: List<suspend GetMulticastDomainFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetMulticastDomainFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("mmgippbqjaiwfnqe")
    public suspend fun filters(vararg argument: suspend GetMulticastDomainFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetMulticastDomainFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("gsjkyrpohnajtlka")
    public suspend fun filters(argument: suspend GetMulticastDomainFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetMulticastDomainFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("gncaguirdwmnblbm")
    public suspend fun filters(vararg values: GetMulticastDomainFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Multicast Domain.
     */
    @JvmName("tbcsqemihouibrqc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Multicast Domain.
     */
    @JvmName("omqxbkqhaktjbvmr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway Multicast Domain.
     */
    @JvmName("mktnlxesunwjjvnk")
    public suspend fun transitGatewayMulticastDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.transitGatewayMulticastDomainId = mapped
    }

    internal fun build(): GetMulticastDomainPlainArgs = GetMulticastDomainPlainArgs(
        filters = filters,
        tags = tags,
        transitGatewayMulticastDomainId = transitGatewayMulticastDomainId,
    )
}
