@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTable.
 * @property filters One or more configuration blocks containing name-values filters. Detailed below.
 * @property id Identifier of the EC2 Transit Gateway Route Table.
 * @property tags Key-value tags for the EC2 Transit Gateway Route Table
 */
public data class GetRouteTablePlainArgs(
    public val filters: List<GetRouteTableFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetRouteTablePlainArgs].
 */
@PulumiTagMarker
public class GetRouteTablePlainArgsBuilder internal constructor() {
    private var filters: List<GetRouteTableFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("nfbpodvecgifnyrd")
    public suspend fun filters(`value`: List<GetRouteTableFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("lnbjsgbvxhwdobcw")
    public suspend fun filters(argument: List<suspend GetRouteTableFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouteTableFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("ovrftmlgofqokyam")
    public suspend fun filters(vararg argument: suspend GetRouteTableFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetRouteTableFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("orpgkukvuphvfytj")
    public suspend fun filters(argument: suspend GetRouteTableFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetRouteTableFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more configuration blocks containing name-values filters. Detailed below.
     */
    @JvmName("gujjxyapkggymacs")
    public suspend fun filters(vararg values: GetRouteTableFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of the EC2 Transit Gateway Route Table.
     */
    @JvmName("brfxmsffmbiclycb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Key-value tags for the EC2 Transit Gateway Route Table
     */
    @JvmName("xpsrodspbcayhifq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the EC2 Transit Gateway Route Table
     */
    @JvmName("hrnyrjdjsjxctbyo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetRouteTablePlainArgs = GetRouteTablePlainArgs(
        filters = filters,
        id = id,
        tags = tags,
    )
}
