@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.inputs

import com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePropagationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouteTablePropagations.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 * @property transitGatewayRouteTableId Identifier of EC2 Transit Gateway Route Table.
 * The following arguments are optional:
 */
public data class GetRouteTablePropagationsPlainArgs(
    public val filters: List<GetRouteTablePropagationsFilter>? = null,
    public val transitGatewayRouteTableId: String,
) : ConvertibleToJava<com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePropagationsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePropagationsPlainArgs =
        com.pulumi.aws.ec2transitgateway.inputs.GetRouteTablePropagationsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .transitGatewayRouteTableId(transitGatewayRouteTableId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTablePropagationsPlainArgs].
 */
@PulumiTagMarker
public class GetRouteTablePropagationsPlainArgsBuilder internal constructor() {
    private var filters: List<GetRouteTablePropagationsFilter>? = null

    private var transitGatewayRouteTableId: String? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("ktnctpiobkivxhpc")
    public suspend fun filters(`value`: List<GetRouteTablePropagationsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("ronbhmmgnrfglneq")
    public suspend
    fun filters(argument: List<suspend GetRouteTablePropagationsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetRouteTablePropagationsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("qbmftvxkutwxvuhd")
    public suspend fun filters(
        vararg
        argument: suspend GetRouteTablePropagationsFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetRouteTablePropagationsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("bjmafjexsdmmsywt")
    public suspend fun filters(argument: suspend GetRouteTablePropagationsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetRouteTablePropagationsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("eyemoptfrlyllrlu")
    public suspend fun filters(vararg values: GetRouteTablePropagationsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of EC2 Transit Gateway Route Table.
     * The following arguments are optional:
     */
    @JvmName("uejlmxexefmovymw")
    public suspend fun transitGatewayRouteTableId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.transitGatewayRouteTableId = mapped
    }

    internal fun build(): GetRouteTablePropagationsPlainArgs = GetRouteTablePropagationsPlainArgs(
        filters = filters,
        transitGatewayRouteTableId = transitGatewayRouteTableId ?: throw
            PulumiNullFieldException("transitGatewayRouteTableId"),
    )
}
