@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name Name of the filter check available value on [official documentation](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html)
 * @property values List of one or more values for the filter.
 */
public data class GetAttachmentsFilter(
    public val name: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetAttachmentsFilter):
            GetAttachmentsFilter = GetAttachmentsFilter(
            name = javaType.name(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
