@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAttachments.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of all attachments ids matching the filter. You can retrieve more information about the attachment using the [aws&#46;ec2transitgateway&#46;getAttachment][2] data source, searching by identifier.
 * @property tags
 */
public data class GetAttachmentsResult(
    public val filters: List<GetAttachmentsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetAttachmentsResult):
            GetAttachmentsResult = GetAttachmentsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetAttachmentsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
