@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getConnectPeer.
 * @property arn EC2 Transit Gateway Connect Peer ARN
 * @property bgpAsn BGP ASN number assigned customer device
 * @property bgpPeerAddress The IP address assigned to customer device, which is used as BGP IP address.
 * @property bgpTransitGatewayAddresses The IP addresses assigned to Transit Gateway, which are used as BGP IP addresses.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property insideCidrBlocks CIDR blocks that will be used for addressing within the tunnel.
 * @property peerAddress IP addressed assigned to customer device, which is used as tunnel endpoint
 * @property tags Key-value tags for the EC2 Transit Gateway Connect Peer
 * @property transitGatewayAddress The IP address assigned to Transit Gateway, which is used as tunnel endpoint.
 * @property transitGatewayAttachmentId The Transit Gateway Connect
 * @property transitGatewayConnectPeerId
 */
public data class GetConnectPeerResult(
    public val arn: String,
    public val bgpAsn: String,
    public val bgpPeerAddress: String,
    public val bgpTransitGatewayAddresses: List<String>,
    public val filters: List<GetConnectPeerFilter>? = null,
    public val id: String,
    public val insideCidrBlocks: List<String>,
    public val peerAddress: String,
    public val tags: Map<String, String>,
    public val transitGatewayAddress: String,
    public val transitGatewayAttachmentId: String,
    public val transitGatewayConnectPeerId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetConnectPeerResult):
            GetConnectPeerResult = GetConnectPeerResult(
            arn = javaType.arn(),
            bgpAsn = javaType.bgpAsn(),
            bgpPeerAddress = javaType.bgpPeerAddress(),
            bgpTransitGatewayAddresses = javaType.bgpTransitGatewayAddresses().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectPeerFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            insideCidrBlocks = javaType.insideCidrBlocks().map({ args0 -> args0 }),
            peerAddress = javaType.peerAddress(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayAddress = javaType.transitGatewayAddress(),
            transitGatewayAttachmentId = javaType.transitGatewayAttachmentId(),
            transitGatewayConnectPeerId = javaType.transitGatewayConnectPeerId(),
        )
    }
}
