@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getConnect.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property protocol Tunnel protocol
 * @property tags Key-value tags for the EC2 Transit Gateway Connect
 * @property transitGatewayConnectId
 * @property transitGatewayId EC2 Transit Gateway identifier
 * @property transportAttachmentId The underlaying VPC attachment
 */
public data class GetConnectResult(
    public val filters: List<GetConnectFilter>? = null,
    public val id: String,
    public val protocol: String,
    public val tags: Map<String, String>,
    public val transitGatewayConnectId: String,
    public val transitGatewayId: String,
    public val transportAttachmentId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetConnectResult):
            GetConnectResult = GetConnectResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetConnectFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            protocol = javaType.protocol(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayConnectId = javaType.transitGatewayConnectId(),
            transitGatewayId = javaType.transitGatewayId(),
            transportAttachmentId = javaType.transportAttachmentId(),
        )
    }
}
