@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDirectConnectGatewayAttachment.
 * @property dxGatewayId
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Key-value tags for the EC2 Transit Gateway Attachment
 * @property transitGatewayId
 */
public data class GetDirectConnectGatewayAttachmentResult(
    public val dxGatewayId: String? = null,
    public val filters: List<GetDirectConnectGatewayAttachmentFilter>? = null,
    public val id: String,
    public val tags: Map<String, String>,
    public val transitGatewayId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetDirectConnectGatewayAttachmentResult):
            GetDirectConnectGatewayAttachmentResult = GetDirectConnectGatewayAttachmentResult(
            dxGatewayId = javaType.dxGatewayId().map({ args0 -> args0 }).orElse(null),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetDirectConnectGatewayAttachmentFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayId = javaType.transitGatewayId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
