@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getMulticastDomain.
 * @property arn EC2 Transit Gateway Multicast Domain ARN.
 * @property associations EC2 Transit Gateway Multicast Domain Associations
 * @property autoAcceptSharedAssociations Whether to automatically accept cross-account subnet associations that are associated with the EC2 Transit Gateway Multicast Domain.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property igmpv2Support Whether to enable Internet Group Management Protocol (IGMP) version 2 for the EC2 Transit Gateway Multicast Domain.
 * @property members EC2 Multicast Domain Group Members
 * @property ownerId Identifier of the AWS account that owns the EC2 Transit Gateway Multicast Domain.
 * @property sources EC2 Multicast Domain Group Sources
 * @property state
 * @property staticSourcesSupport Whether to enable support for statically configuring multicast group sources for the EC2 Transit Gateway Multicast Domain.
 * @property tags Key-value tags for the EC2 Transit Gateway Multicast Domain.
 * @property transitGatewayAttachmentId The ID of the transit gateway attachment.
 * @property transitGatewayId EC2 Transit Gateway identifier.
 * @property transitGatewayMulticastDomainId
 */
public data class GetMulticastDomainResult(
    public val arn: String,
    public val associations: List<GetMulticastDomainAssociation>,
    public val autoAcceptSharedAssociations: String,
    public val filters: List<GetMulticastDomainFilter>? = null,
    public val id: String,
    public val igmpv2Support: String,
    public val members: List<GetMulticastDomainMember>,
    public val ownerId: String,
    public val sources: List<GetMulticastDomainSource>,
    public val state: String,
    public val staticSourcesSupport: String,
    public val tags: Map<String, String>,
    public val transitGatewayAttachmentId: String,
    public val transitGatewayId: String,
    public val transitGatewayMulticastDomainId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetMulticastDomainResult):
            GetMulticastDomainResult = GetMulticastDomainResult(
            arn = javaType.arn(),
            associations = javaType.associations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainAssociation.Companion.toKotlin(args0)
                })
            }),
            autoAcceptSharedAssociations = javaType.autoAcceptSharedAssociations(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            igmpv2Support = javaType.igmpv2Support(),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainMember.Companion.toKotlin(args0)
                })
            }),
            ownerId = javaType.ownerId(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetMulticastDomainSource.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
            staticSourcesSupport = javaType.staticSourcesSupport(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayAttachmentId = javaType.transitGatewayAttachmentId(),
            transitGatewayId = javaType.transitGatewayId(),
            transitGatewayMulticastDomainId = javaType.transitGatewayMulticastDomainId(),
        )
    }
}
