@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getPeeringAttachment.
 * @property filters
 * @property id
 * @property peerAccountId Identifier of the peer AWS account
 * @property peerRegion Identifier of the peer AWS region
 * @property peerTransitGatewayId Identifier of the peer EC2 Transit Gateway
 * @property tags
 * @property transitGatewayId Identifier of the local EC2 Transit Gateway
 */
public data class GetPeeringAttachmentResult(
    public val filters: List<GetPeeringAttachmentFilter>? = null,
    public val id: String,
    public val peerAccountId: String,
    public val peerRegion: String,
    public val peerTransitGatewayId: String,
    public val tags: Map<String, String>,
    public val transitGatewayId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetPeeringAttachmentResult):
            GetPeeringAttachmentResult = GetPeeringAttachmentResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetPeeringAttachmentFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            peerAccountId = javaType.peerAccountId(),
            peerRegion = javaType.peerRegion(),
            peerTransitGatewayId = javaType.peerTransitGatewayId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayId = javaType.transitGatewayId(),
        )
    }
}
