@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteTableRoutes.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property routes List of Transit Gateway Routes.
 * @property transitGatewayRouteTableId
 */
public data class GetRouteTableRoutesResult(
    public val filters: List<GetRouteTableRoutesFilter>,
    public val id: String,
    public val routes: List<GetRouteTableRoutesRoute>,
    public val transitGatewayRouteTableId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetRouteTableRoutesResult):
            GetRouteTableRoutesResult = GetRouteTableRoutesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableRoutesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetRouteTableRoutesRoute.Companion.toKotlin(args0)
                })
            }),
            transitGatewayRouteTableId = javaType.transitGatewayRouteTableId(),
        )
    }
}
