@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2transitgateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getTransitGateway.
 * @property amazonSideAsn Private Autonomous System Number (ASN) for the Amazon side of a BGP session
 * @property arn EC2 Transit Gateway ARN
 * @property associationDefaultRouteTableId Identifier of the default association route table
 * @property autoAcceptSharedAttachments Whether resource attachment requests are automatically accepted
 * @property defaultRouteTableAssociation Whether resource attachments are automatically associated with the default association route table
 * @property defaultRouteTablePropagation Whether resource attachments automatically propagate routes to the default propagation route table
 * @property description Description of the EC2 Transit Gateway
 * @property dnsSupport Whether DNS support is enabled
 * @property filters
 * @property id EC2 Transit Gateway identifier
 * @property multicastSupport Whether Multicast support is enabled
 * @property ownerId Identifier of the AWS account that owns the EC2 Transit Gateway
 * @property propagationDefaultRouteTableId Identifier of the default propagation route table
 * @property tags Key-value tags for the EC2 Transit Gateway
 * @property transitGatewayCidrBlocks The list of associated CIDR blocks
 * @property vpnEcmpSupport Whether VPN Equal Cost Multipath Protocol support is enabled
 */
public data class GetTransitGatewayResult(
    public val amazonSideAsn: Int,
    public val arn: String,
    public val associationDefaultRouteTableId: String,
    public val autoAcceptSharedAttachments: String,
    public val defaultRouteTableAssociation: String,
    public val defaultRouteTablePropagation: String,
    public val description: String,
    public val dnsSupport: String,
    public val filters: List<GetTransitGatewayFilter>? = null,
    public val id: String,
    public val multicastSupport: String,
    public val ownerId: String,
    public val propagationDefaultRouteTableId: String,
    public val tags: Map<String, String>,
    public val transitGatewayCidrBlocks: List<String>,
    public val vpnEcmpSupport: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2transitgateway.outputs.GetTransitGatewayResult):
            GetTransitGatewayResult = GetTransitGatewayResult(
            amazonSideAsn = javaType.amazonSideAsn(),
            arn = javaType.arn(),
            associationDefaultRouteTableId = javaType.associationDefaultRouteTableId(),
            autoAcceptSharedAttachments = javaType.autoAcceptSharedAttachments(),
            defaultRouteTableAssociation = javaType.defaultRouteTableAssociation(),
            defaultRouteTablePropagation = javaType.defaultRouteTablePropagation(),
            description = javaType.description(),
            dnsSupport = javaType.dnsSupport(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2transitgateway.kotlin.outputs.GetTransitGatewayFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            multicastSupport = javaType.multicastSupport(),
            ownerId = javaType.ownerId(),
            propagationDefaultRouteTableId = javaType.propagationDefaultRouteTableId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitGatewayCidrBlocks = javaType.transitGatewayCidrBlocks().map({ args0 -> args0 }),
            vpnEcmpSupport = javaType.vpnEcmpSupport(),
        )
    }
}
