@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.EcrFunctions.getAuthorizationTokenPlain
import com.pulumi.aws.ecr.EcrFunctions.getCredentialsPlain
import com.pulumi.aws.ecr.EcrFunctions.getImagePlain
import com.pulumi.aws.ecr.EcrFunctions.getPullThroughCacheRulePlain
import com.pulumi.aws.ecr.EcrFunctions.getRepositoryPlain
import com.pulumi.aws.ecr.kotlin.inputs.GetAuthorizationTokenPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetAuthorizationTokenPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetCredentialsPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetCredentialsPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetImagePlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetImagePlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetPullThroughCacheRulePlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetPullThroughCacheRulePlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.inputs.GetRepositoryPlainArgs
import com.pulumi.aws.ecr.kotlin.inputs.GetRepositoryPlainArgsBuilder
import com.pulumi.aws.ecr.kotlin.outputs.GetAuthorizationTokenResult
import com.pulumi.aws.ecr.kotlin.outputs.GetCredentialsResult
import com.pulumi.aws.ecr.kotlin.outputs.GetImageResult
import com.pulumi.aws.ecr.kotlin.outputs.GetPullThroughCacheRuleResult
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ecr.kotlin.outputs.GetAuthorizationTokenResult.Companion.toKotlin as getAuthorizationTokenResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetCredentialsResult.Companion.toKotlin as getCredentialsResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetImageResult.Companion.toKotlin as getImageResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetPullThroughCacheRuleResult.Companion.toKotlin as getPullThroughCacheRuleResultToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.GetRepositoryResult.Companion.toKotlin as getRepositoryResultToKotlin

public object EcrFunctions {
    /**
     * The ECR Authorization Token data source allows the authorization token, proxy endpoint, token expiration date, user name and password to be retrieved for an ECR repository.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetAuthorizationTokenArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var token = EcrFunctions.getAuthorizationToken();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAuthorizationToken.
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(argument: GetAuthorizationTokenPlainArgs):
        GetAuthorizationTokenResult =
        getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(argument.toJava()).await())

    /**
     * @see [getAuthorizationToken].
     * @param registryId AWS account ID of the ECR Repository. If not specified the default account is assumed.
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend fun getAuthorizationToken(registryId: String? = null):
        GetAuthorizationTokenResult {
        val argument = GetAuthorizationTokenPlainArgs(
            registryId = registryId,
        )
        return getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getAuthorizationToken].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetAuthorizationTokenPlainArgs].
     * @return A collection of values returned by getAuthorizationToken.
     */
    public suspend
    fun getAuthorizationToken(argument: suspend GetAuthorizationTokenPlainArgsBuilder.() -> Unit):
        GetAuthorizationTokenResult {
        val builder = GetAuthorizationTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAuthorizationTokenResultToKotlin(getAuthorizationTokenPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getCredentials.
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(argument: GetCredentialsPlainArgs): GetCredentialsResult =
        getCredentialsResultToKotlin(getCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getCredentials].
     * @param registryId
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(registryId: String): GetCredentialsResult {
        val argument = GetCredentialsPlainArgs(
            registryId = registryId,
        )
        return getCredentialsResultToKotlin(getCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetCredentialsPlainArgs].
     * @return A collection of values returned by getCredentials.
     */
    public suspend fun getCredentials(argument: suspend GetCredentialsPlainArgsBuilder.() -> Unit):
        GetCredentialsResult {
        val builder = GetCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialsResultToKotlin(getCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * The ECR Image data source allows the details of an image with a particular tag or digest to be retrieved.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetImageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var serviceImage = EcrFunctions.getImage(GetImageArgs.builder()
     *             .imageTag("latest")
     *             .repositoryName("my/service")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImage.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: GetImagePlainArgs): GetImageResult =
        getImageResultToKotlin(getImagePlain(argument.toJava()).await())

    /**
     * @see [getImage].
     * @param imageDigest Sha256 digest of the image manifest. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     * @param imageTag Tag associated with this image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     * @param mostRecent Return the most recently pushed image. At least one of `image_digest`, `image_tag`, or `most_recent` must be specified.
     * @param registryId ID of the Registry where the repository resides.
     * @param repositoryName Name of the ECR Repository.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(
        imageDigest: String? = null,
        imageTag: String? = null,
        mostRecent: Boolean? = null,
        registryId: String? = null,
        repositoryName: String,
    ): GetImageResult {
        val argument = GetImagePlainArgs(
            imageDigest = imageDigest,
            imageTag = imageTag,
            mostRecent = mostRecent,
            registryId = registryId,
            repositoryName = repositoryName,
        )
        return getImageResultToKotlin(getImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetImagePlainArgs].
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: suspend GetImagePlainArgsBuilder.() -> Unit):
        GetImageResult {
        val builder = GetImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageResultToKotlin(getImagePlain(builtArgument.toJava()).await())
    }

    /**
     * The ECR Pull Through Cache Rule data source allows the upstream registry URL and registry ID to be retrieved for a Pull Through Cache Rule.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetPullThroughCacheRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ecrPublic = EcrFunctions.getPullThroughCacheRule(GetPullThroughCacheRuleArgs.builder()
     *             .ecrRepositoryPrefix("ecr-public")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPullThroughCacheRule.
     * @return A collection of values returned by getPullThroughCacheRule.
     */
    public suspend fun getPullThroughCacheRule(argument: GetPullThroughCacheRulePlainArgs):
        GetPullThroughCacheRuleResult =
        getPullThroughCacheRuleResultToKotlin(getPullThroughCacheRulePlain(argument.toJava()).await())

    /**
     * @see [getPullThroughCacheRule].
     * @param ecrRepositoryPrefix The repository name prefix to use when caching images from the source registry.
     * @return A collection of values returned by getPullThroughCacheRule.
     */
    public suspend fun getPullThroughCacheRule(ecrRepositoryPrefix: String):
        GetPullThroughCacheRuleResult {
        val argument = GetPullThroughCacheRulePlainArgs(
            ecrRepositoryPrefix = ecrRepositoryPrefix,
        )
        return getPullThroughCacheRuleResultToKotlin(getPullThroughCacheRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPullThroughCacheRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetPullThroughCacheRulePlainArgs].
     * @return A collection of values returned by getPullThroughCacheRule.
     */
    public suspend
    fun getPullThroughCacheRule(argument: suspend GetPullThroughCacheRulePlainArgsBuilder.() -> Unit):
        GetPullThroughCacheRuleResult {
        val builder = GetPullThroughCacheRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPullThroughCacheRuleResultToKotlin(getPullThroughCacheRulePlain(builtArgument.toJava()).await())
    }

    /**
     * The ECR Repository data source allows the ARN, Repository URI and Registry ID to be retrieved for an ECR repository.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ecr.EcrFunctions;
     * import com.pulumi.aws.ecr.inputs.GetRepositoryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var service = EcrFunctions.getRepository(GetRepositoryArgs.builder()
     *             .name("ecr-repository")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRepository.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: GetRepositoryPlainArgs): GetRepositoryResult =
        getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())

    /**
     * @see [getRepository].
     * @param name Name of the ECR Repository.
     * @param registryId Registry ID where the repository was created.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(
        name: String,
        registryId: String? = null,
        tags: Map<String, String>? = null,
    ): GetRepositoryResult {
        val argument = GetRepositoryPlainArgs(
            name = name,
            registryId = registryId,
            tags = tags,
        )
        return getRepositoryResultToKotlin(getRepositoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getRepository].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ecr&#46;kotlin&#46;inputs&#46;GetRepositoryPlainArgs].
     * @return A collection of values returned by getRepository.
     */
    public suspend fun getRepository(argument: suspend GetRepositoryPlainArgsBuilder.() -> Unit):
        GetRepositoryResult {
        val builder = GetRepositoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryResultToKotlin(getRepositoryPlain(builtArgument.toJava()).await())
    }
}
