@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PullThroughCacheRule].
 */
@PulumiTagMarker
public class PullThroughCacheRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PullThroughCacheRuleArgs = PullThroughCacheRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PullThroughCacheRuleArgsBuilder.() -> Unit) {
        val builder = PullThroughCacheRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PullThroughCacheRule {
        val builtJavaResource = com.pulumi.aws.ecr.PullThroughCacheRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PullThroughCacheRule(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Pull Through Cache Rule.
 * More information about pull through cache rules, including the set of supported
 * upstream repositories, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.PullThroughCacheRule;
 * import com.pulumi.aws.ecr.PullThroughCacheRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PullThroughCacheRule("example", PullThroughCacheRuleArgs.builder()
 *             .ecrRepositoryPrefix("ecr-public")
 *             .upstreamRegistryUrl("public.ecr.aws")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a pull-through cache rule using the `ecr_repository_prefix`. For example:
 * ```sh
 *  $ pulumi import aws:ecr/pullThroughCacheRule:PullThroughCacheRule example ecr-public
 * ```
 *
 */
public class PullThroughCacheRule internal constructor(
    override val javaResource: com.pulumi.aws.ecr.PullThroughCacheRule,
) : KotlinCustomResource(javaResource, PullThroughCacheRuleMapper) {
    /**
     * The repository name prefix to use when caching images from the source registry.
     */
    public val ecrRepositoryPrefix: Output<String>
        get() = javaResource.ecrRepositoryPrefix().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the repository was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * The registry URL of the upstream public registry to use as the source.
     */
    public val upstreamRegistryUrl: Output<String>
        get() = javaResource.upstreamRegistryUrl().applyValue({ args0 -> args0 })
}

public object PullThroughCacheRuleMapper : ResourceMapper<PullThroughCacheRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.PullThroughCacheRule::class == javaResource::class

    override fun map(javaResource: Resource): PullThroughCacheRule = PullThroughCacheRule(
        javaResource
            as com.pulumi.aws.ecr.PullThroughCacheRule,
    )
}

/**
 * @see [PullThroughCacheRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PullThroughCacheRule].
 */
public suspend fun pullThroughCacheRule(
    name: String,
    block: suspend PullThroughCacheRuleResourceBuilder.() -> Unit,
): PullThroughCacheRule {
    val builder = PullThroughCacheRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PullThroughCacheRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pullThroughCacheRule(name: String): PullThroughCacheRule {
    val builder = PullThroughCacheRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
