@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.PullThroughCacheRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Pull Through Cache Rule.
 * More information about pull through cache rules, including the set of supported
 * upstream repositories, see [Using pull through cache rules](https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.PullThroughCacheRule;
 * import com.pulumi.aws.ecr.PullThroughCacheRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PullThroughCacheRule("example", PullThroughCacheRuleArgs.builder()
 *             .ecrRepositoryPrefix("ecr-public")
 *             .upstreamRegistryUrl("public.ecr.aws")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a pull-through cache rule using the `ecr_repository_prefix`. For example:
 * ```sh
 *  $ pulumi import aws:ecr/pullThroughCacheRule:PullThroughCacheRule example ecr-public
 * ```
 * @property ecrRepositoryPrefix The repository name prefix to use when caching images from the source registry.
 * @property upstreamRegistryUrl The registry URL of the upstream public registry to use as the source.
 */
public data class PullThroughCacheRuleArgs(
    public val ecrRepositoryPrefix: Output<String>? = null,
    public val upstreamRegistryUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.PullThroughCacheRuleArgs> {
    override fun toJava(): com.pulumi.aws.ecr.PullThroughCacheRuleArgs =
        com.pulumi.aws.ecr.PullThroughCacheRuleArgs.builder()
            .ecrRepositoryPrefix(ecrRepositoryPrefix?.applyValue({ args0 -> args0 }))
            .upstreamRegistryUrl(upstreamRegistryUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PullThroughCacheRuleArgs].
 */
@PulumiTagMarker
public class PullThroughCacheRuleArgsBuilder internal constructor() {
    private var ecrRepositoryPrefix: Output<String>? = null

    private var upstreamRegistryUrl: Output<String>? = null

    /**
     * @param value The repository name prefix to use when caching images from the source registry.
     */
    @JvmName("mxsdqxndislhkdrc")
    public suspend fun ecrRepositoryPrefix(`value`: Output<String>) {
        this.ecrRepositoryPrefix = value
    }

    /**
     * @param value The registry URL of the upstream public registry to use as the source.
     */
    @JvmName("dswstyktgcvficdg")
    public suspend fun upstreamRegistryUrl(`value`: Output<String>) {
        this.upstreamRegistryUrl = value
    }

    /**
     * @param value The repository name prefix to use when caching images from the source registry.
     */
    @JvmName("obwyihodmathqhsc")
    public suspend fun ecrRepositoryPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrRepositoryPrefix = mapped
    }

    /**
     * @param value The registry URL of the upstream public registry to use as the source.
     */
    @JvmName("bokmlpvqlvfqvnsv")
    public suspend fun upstreamRegistryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upstreamRegistryUrl = mapped
    }

    internal fun build(): PullThroughCacheRuleArgs = PullThroughCacheRuleArgs(
        ecrRepositoryPrefix = ecrRepositoryPrefix,
        upstreamRegistryUrl = upstreamRegistryUrl,
    )
}
