@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegistryPolicy].
 */
@PulumiTagMarker
public class RegistryPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryPolicyArgs = RegistryPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryPolicyArgsBuilder.() -> Unit) {
        val builder = RegistryPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegistryPolicy {
        val builtJavaResource = com.pulumi.aws.ecr.RegistryPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegistryPolicy(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.ecr.RegistryPolicy;
 * import com.pulumi.aws.ecr.RegistryPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var example = new RegistryPolicy("example", RegistryPolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "testpolicy"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray("ecr:ReplicateImage")),
 *                         jsonProperty("Resource", jsonArray(String.format("arn:%s:ecr:%s:%s:repository/*", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Registry Policy using the registry id. For example:
 * ```sh
 *  $ pulumi import aws:ecr/registryPolicy:RegistryPolicy example 123456789012
 * ```
 * */
 */
public class RegistryPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ecr.RegistryPolicy,
) : KotlinCustomResource(javaResource, RegistryPolicyMapper) {
    /**
     * The policy document. This is a JSON formatted string.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the registry was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })
}

public object RegistryPolicyMapper : ResourceMapper<RegistryPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.RegistryPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RegistryPolicy = RegistryPolicy(
        javaResource as
            com.pulumi.aws.ecr.RegistryPolicy,
    )
}

/**
 * @see [RegistryPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryPolicy].
 */
public suspend fun registryPolicy(
    name: String,
    block: suspend RegistryPolicyResourceBuilder.() -> Unit,
): RegistryPolicy {
    val builder = RegistryPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryPolicy(name: String): RegistryPolicy {
    val builder = RegistryPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
