@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.RegistryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Policy.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.ecr.RegistryPolicy;
 * import com.pulumi.aws.ecr.RegistryPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentCallerIdentity = AwsFunctions.getCallerIdentity();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         final var currentPartition = AwsFunctions.getPartition();
 *         var example = new RegistryPolicy("example", RegistryPolicyArgs.builder()
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "testpolicy"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", String.format("arn:%s:iam::%s:root", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         )),
 *                         jsonProperty("Action", jsonArray("ecr:ReplicateImage")),
 *                         jsonProperty("Resource", jsonArray(String.format("arn:%s:ecr:%s:%s:repository/*", currentPartition.applyValue(getPartitionResult -> getPartitionResult.partition()),currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Registry Policy using the registry id. For example:
 * ```sh
 *  $ pulumi import aws:ecr/registryPolicy:RegistryPolicy example 123456789012
 * ```
 * @property policy The policy document. This is a JSON formatted string.
 * */
 */
public data class RegistryPolicyArgs(
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.RegistryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.ecr.RegistryPolicyArgs =
        com.pulumi.aws.ecr.RegistryPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryPolicyArgs].
 */
@PulumiTagMarker
public class RegistryPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("tuavjxfooapylyel")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("jksxkkvpgolukysm")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): RegistryPolicyArgs = RegistryPolicyArgs(
        policy = policy,
    )
}
