@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.kotlin.outputs.RegistryScanningConfigurationRule
import com.pulumi.aws.ecr.kotlin.outputs.RegistryScanningConfigurationRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RegistryScanningConfiguration].
 */
@PulumiTagMarker
public class RegistryScanningConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryScanningConfigurationArgs = RegistryScanningConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryScanningConfigurationArgsBuilder.() -> Unit) {
        val builder = RegistryScanningConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegistryScanningConfiguration {
        val builtJavaResource =
            com.pulumi.aws.ecr.RegistryScanningConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryScanningConfiguration(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Scanning Configuration. Can't be completely deleted, instead reverts to the default `BASIC` scanning configuration without rules.
 * ## Example Usage
 * ### Basic example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.RegistryScanningConfiguration;
 * import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configuration = new RegistryScanningConfiguration("configuration", RegistryScanningConfigurationArgs.builder()
 *             .rules(RegistryScanningConfigurationRuleArgs.builder()
 *                 .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                     .filter("example")
 *                     .filterType("WILDCARD")
 *                     .build())
 *                 .scanFrequency("CONTINUOUS_SCAN")
 *                 .build())
 *             .scanType("ENHANCED")
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.RegistryScanningConfiguration;
 * import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RegistryScanningConfiguration("test", RegistryScanningConfigurationArgs.builder()
 *             .rules(
 *                 RegistryScanningConfigurationRuleArgs.builder()
 *                     .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("*")
 *                         .filterType("WILDCARD")
 *                         .build())
 *                     .scanFrequency("SCAN_ON_PUSH")
 *                     .build(),
 *                 RegistryScanningConfigurationRuleArgs.builder()
 *                     .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("example")
 *                         .filterType("WILDCARD")
 *                         .build())
 *                     .scanFrequency("CONTINUOUS_SCAN")
 *                     .build())
 *             .scanType("ENHANCED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Scanning Configurations using the `registry_id`. For example:
 * ```sh
 *  $ pulumi import aws:ecr/registryScanningConfiguration:RegistryScanningConfiguration example 012345678901
 * ```
 *
 */
public class RegistryScanningConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.ecr.RegistryScanningConfiguration,
) : KotlinCustomResource(javaResource, RegistryScanningConfigurationMapper) {
    /**
     * The registry ID the scanning configuration applies to.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    public val rules: Output<List<RegistryScanningConfigurationRule>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
     */
    public val scanType: Output<String>
        get() = javaResource.scanType().applyValue({ args0 -> args0 })
}

public object RegistryScanningConfigurationMapper : ResourceMapper<RegistryScanningConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.RegistryScanningConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): RegistryScanningConfiguration =
        RegistryScanningConfiguration(
            javaResource as
                com.pulumi.aws.ecr.RegistryScanningConfiguration,
        )
}

/**
 * @see [RegistryScanningConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryScanningConfiguration].
 */
public suspend fun registryScanningConfiguration(
    name: String,
    block: suspend RegistryScanningConfigurationResourceBuilder.() -> Unit,
):
    RegistryScanningConfiguration {
    val builder = RegistryScanningConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryScanningConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryScanningConfiguration(name: String): RegistryScanningConfiguration {
    val builder = RegistryScanningConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
