@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs.builder
import com.pulumi.aws.ecr.kotlin.inputs.RegistryScanningConfigurationRuleArgs
import com.pulumi.aws.ecr.kotlin.inputs.RegistryScanningConfigurationRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Container Registry Scanning Configuration. Can't be completely deleted, instead reverts to the default `BASIC` scanning configuration without rules.
 * ## Example Usage
 * ### Basic example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.RegistryScanningConfiguration;
 * import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configuration = new RegistryScanningConfiguration("configuration", RegistryScanningConfigurationArgs.builder()
 *             .rules(RegistryScanningConfigurationRuleArgs.builder()
 *                 .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                     .filter("example")
 *                     .filterType("WILDCARD")
 *                     .build())
 *                 .scanFrequency("CONTINUOUS_SCAN")
 *                 .build())
 *             .scanType("ENHANCED")
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple rules
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.RegistryScanningConfiguration;
 * import com.pulumi.aws.ecr.RegistryScanningConfigurationArgs;
 * import com.pulumi.aws.ecr.inputs.RegistryScanningConfigurationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RegistryScanningConfiguration("test", RegistryScanningConfigurationArgs.builder()
 *             .rules(
 *                 RegistryScanningConfigurationRuleArgs.builder()
 *                     .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("*")
 *                         .filterType("WILDCARD")
 *                         .build())
 *                     .scanFrequency("SCAN_ON_PUSH")
 *                     .build(),
 *                 RegistryScanningConfigurationRuleArgs.builder()
 *                     .repositoryFilters(RegistryScanningConfigurationRuleRepositoryFilterArgs.builder()
 *                         .filter("example")
 *                         .filterType("WILDCARD")
 *                         .build())
 *                     .scanFrequency("CONTINUOUS_SCAN")
 *                     .build())
 *             .scanType("ENHANCED")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Scanning Configurations using the `registry_id`. For example:
 * ```sh
 *  $ pulumi import aws:ecr/registryScanningConfiguration:RegistryScanningConfiguration example 012345678901
 * ```
 * @property rules One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
 * @property scanType the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
 */
public data class RegistryScanningConfigurationArgs(
    public val rules: Output<List<RegistryScanningConfigurationRuleArgs>>? = null,
    public val scanType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ecr.RegistryScanningConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ecr.RegistryScanningConfigurationArgs =
        com.pulumi.aws.ecr.RegistryScanningConfigurationArgs.builder()
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scanType(scanType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryScanningConfigurationArgs].
 */
@PulumiTagMarker
public class RegistryScanningConfigurationArgsBuilder internal constructor() {
    private var rules: Output<List<RegistryScanningConfigurationRuleArgs>>? = null

    private var scanType: Output<String>? = null

    /**
     * @param value One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("dyulisuduokldolg")
    public suspend fun rules(`value`: Output<List<RegistryScanningConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("mwnfomydydwhvmyd")
    public suspend fun rules(vararg values: Output<RegistryScanningConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("sqyuegnlukqevhxc")
    public suspend fun rules(values: List<Output<RegistryScanningConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
     */
    @JvmName("mnflgvrjvdownrep")
    public suspend fun scanType(`value`: Output<String>) {
        this.scanType = value
    }

    /**
     * @param value One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("oqycshdbviucjltv")
    public suspend fun rules(`value`: List<RegistryScanningConfigurationRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("ceekpikbklccmmvq")
    public suspend
    fun rules(argument: List<suspend RegistryScanningConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegistryScanningConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("fwjpuymqeutoebkq")
    public suspend fun rules(
        vararg
        argument: suspend RegistryScanningConfigurationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RegistryScanningConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("facbgnqsdnbtyeod")
    public suspend
    fun rules(argument: suspend RegistryScanningConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegistryScanningConfigurationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values One or multiple blocks specifying scanning rules to determine which repository filters are used and at what frequency scanning will occur. See below for schema.
     */
    @JvmName("ngheyudmvekwiawv")
    public suspend fun rules(vararg values: RegistryScanningConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value the scanning type to set for the registry. Can be either `ENHANCED` or `BASIC`.
     */
    @JvmName("oduunlrufyljvdcm")
    public suspend fun scanType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    internal fun build(): RegistryScanningConfigurationArgs = RegistryScanningConfigurationArgs(
        rules = rules,
        scanType = scanType,
    )
}
