@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecr.kotlin

import com.pulumi.aws.ecr.kotlin.outputs.RepositoryEncryptionConfiguration
import com.pulumi.aws.ecr.kotlin.outputs.RepositoryImageScanningConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ecr.kotlin.outputs.RepositoryEncryptionConfiguration.Companion.toKotlin as repositoryEncryptionConfigurationToKotlin
import com.pulumi.aws.ecr.kotlin.outputs.RepositoryImageScanningConfiguration.Companion.toKotlin as repositoryImageScanningConfigurationToKotlin

/**
 * Builder for [Repository].
 */
@PulumiTagMarker
public class RepositoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryArgs = RepositoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryArgsBuilder.() -> Unit) {
        val builder = RepositoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Repository {
        val builtJavaResource = com.pulumi.aws.ecr.Repository(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Repository(builtJavaResource)
    }
}

/**
 * Provides an Elastic Container Registry Repository.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ecr.Repository;
 * import com.pulumi.aws.ecr.RepositoryArgs;
 * import com.pulumi.aws.ecr.inputs.RepositoryImageScanningConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Repository("foo", RepositoryArgs.builder()
 *             .imageScanningConfiguration(RepositoryImageScanningConfigurationArgs.builder()
 *                 .scanOnPush(true)
 *                 .build())
 *             .imageTagMutability("MUTABLE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ECR Repositories using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:ecr/repository:Repository service test-service
 * ```
 *
 */
public class Repository internal constructor(
    override val javaResource: com.pulumi.aws.ecr.Repository,
) : KotlinCustomResource(javaResource, RepositoryMapper) {
    /**
     * Full ARN of the repository.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Encryption configuration for the repository. See below for schema.
     */
    public val encryptionConfigurations: Output<List<RepositoryEncryptionConfiguration>>?
        get() = javaResource.encryptionConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        repositoryEncryptionConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * If `true`, will delete the repository even if it contains images.
     * Defaults to `false`.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block that defines image scanning configuration for the repository. By default, image scanning must be manually triggered. See the [ECR User Guide](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) for more information about image scanning.
     */
    public val imageScanningConfiguration: Output<RepositoryImageScanningConfiguration>?
        get() = javaResource.imageScanningConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> repositoryImageScanningConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The tag mutability setting for the repository. Must be one of: `MUTABLE` or `IMMUTABLE`. Defaults to `MUTABLE`.
     */
    public val imageTagMutability: Output<String>?
        get() = javaResource.imageTagMutability().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the repository.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The registry ID where the repository was created.
     */
    public val registryId: Output<String>
        get() = javaResource.registryId().applyValue({ args0 -> args0 })

    /**
     * The URL of the repository (in the form `aws_account_id.dkr.ecr.region.amazonaws.com/repositoryName`).
     */
    public val repositoryUrl: Output<String>
        get() = javaResource.repositoryUrl().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RepositoryMapper : ResourceMapper<Repository> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ecr.Repository::class == javaResource::class

    override fun map(javaResource: Resource): Repository = Repository(
        javaResource as
            com.pulumi.aws.ecr.Repository,
    )
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Repository].
 */
public suspend fun repository(name: String, block: suspend RepositoryResourceBuilder.() -> Unit):
    Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Repository].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repository(name: String): Repository {
    val builder = RepositoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
